% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_true_param_aniso_sim}
\alias{get_true_param_aniso_sim}
\title{Transform parameters in anisotropic simulation class to parameters structure in MSD function}
\usage{
get_true_param_aniso_sim(param_truth, model_name)
}
\arguments{
\item{param_truth}{parameters used in \code{aniso_simulation} class}

\item{model_name}{stochastic process used in \code{aniso_simulation}, options from
('BM','OU','FBM','OU+FBM')}
}
\value{
A vector of parameters contained in MSD with structure \code{theta} in
\code{\link{get_MSD}}.
}
\description{
Transform parameters in \code{aniso_simulation} class to parameters contained in MSD
function with structure \code{theta} in \code{\link{get_MSD}}. Prepare for
truth MSD construction.
}
\examples{
library(AIUQ)
# Simulate simple diffusion for 100 images with 100 by 100 pixels and
# distance moved per time step is 0.5
aniso_sim_bm = aniso_simulation(sz=100,len_t=100,sigma_bm=c(0.5,0.1))
show(aniso_sim_bm)
get_true_param_aniso_sim(param_truth=aniso_sim_bm@param,model_name=aniso_sim_bm@model_name)

}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
