% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahr.R
\name{ahrUser}
\alias{ahrUser}
\title{ahrUser}
\usage{
ahrUser(L, formula, data, null.theta = NULL, contrast = NULL,
  multi.test = FALSE, cov = FALSE, bootstrap = 0,
  user.survfit = wkm, user.param = list(alpha = 1, var = FALSE, cov =
  FALSE, left.limit = FALSE, rr.subset = rep(TRUE, nrow(data))))
}
\arguments{
\item{L}{time-limit specifying time-interval [0,L] over which average hazard ratios will be calculated}

\item{formula}{an object of class '"formula"' specifying the conditional survival model}

\item{data}{data frame containing the variables in formula}

\item{null.theta}{vector specifying the null hypothesis for the average hazard ratios (H_0: theta = null.theta)}

\item{contrast}{vector of contrasts to test H_0: contrast * (theta - null.theta) = 0}

\item{multi.test}{calculate multivariate test statistic if TRUE}

\item{cov}{if TRUE calculate covariance matrix estimator (direct)}

\item{bootstrap}{if > 0 then use bootstrap to estimate covariance matrix (ignore if cov is TRUE)}

\item{user.survfit}{user defined function taking vector of times, data.frame and list of parameters returning survival function estimate}

\item{user.param}{list of parameters passed to function user.survfit}
}
\value{
An object of class '"ahr"'
}
\description{
Estimate average hazard ratios from k independent samples based on user-supplied survival function estimator
}
\details{
user.survfit must return logV (if user supplied survival function estimator hast independent increments property) or logCOV
}
\examples{
## User supplied survival function estimator (should be exactly the same as
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
time <- pmin(T, C)
status <- T <= C
trt <- rep(c(0,1), c(100, 100)) # treatment indicator

sfit <- function(times, data, param) {
  fit <- survfit(Surv(Y, D) ~ 1, data=data)
  f <- approxfun(fit$time, fit$surv, method="constant", f=0, yleft=1, rule=2)
  fv <- approxfun(fit$time, fit$std.err^2, method="constant", f=0, yleft=1, rule=2)

  S <- f(times)
  logV <- fv(times) * nrow(data)
  V <- S^2 * logV

  list(times=times, S=S, V=V, logV=logV)
}
fit1 <- ahrUser(2, Surv(time, status) ~ trt,
                data.frame(time=time, status=status, trt=trt), user.survfit=sfit, user.param=list())
fit1
fit2 <- ahrKM(2, Surv(time, status) ~ trt, data.frame(time=time, status=status, trt=trt), cov=FALSE)
fit2

}
\references{
J.~D. Kalbfleisch and R.~L. Prentice. Estimation of the average hazard ratio. \emph{Biometrika}, 68(1):105--112, Apr. 1981.
}
\seealso{
\code{\link{wkm}}
}
