% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImageAnalyser.R
\name{analyse}
\alias{analyse}
\title{Analyse an AFMImage}
\usage{
analyse(AFMImageAnalyser)
}
\arguments{
\item{AFMImageAnalyser}{a \code{\link{AFMImageAnalyser}} to manage and store image analysis}
}
\value{
an \code{\link{AFMImageAnalyser}} containing all the analysis
}
\description{
A function to wrap all the analysis of an \code{\link{AFMImage}}
\itemize{
  \item variogram analysis  including evaluation of basic variogram models with sill and range calculation
  \item power spectrum density analysis including roughness against lengthscale calculation
  \item fractal dimension analysis including fractal dimensions calculation
  \item basic roughness parameters analysis such as mean, variance, Rrms, Ra
}
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
AFMImage<-extractAFMImage(AFMImageOfAluminiumInterface, 0, 0, 32)
AFMImageAnalyser<-new("AFMImageAnalyser", AFMImage= AFMImage, fullfilename = AFMImage@fullfilename)
AFMImageAnalyser<-analyse(AFMImageAnalyser)
print(AFMImageAnalyser@fdAnalysis)

}
\author{
M.Beauvais
}

