% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admm.lad.R
\name{admm.lad}
\alias{admm.lad}
\title{Least Absolute Deviations}
\usage{
admm.lad(A, b, xinit = NA, rho = 1, alpha = 1, abstol = 1e-04,
  reltol = 0.01, maxiter = 1000)
}
\arguments{
\item{A}{an \eqn{(m\times n)} regressor matrix}

\item{b}{a length-\eqn{m} response vector}

\item{xinit}{a length-\eqn{n} vector for initial value}

\item{rho}{an augmented Lagrangian parameter}

\item{alpha}{an overrelaxation parameter in [1,2]}

\item{abstol}{absolute tolerance stopping criterion}

\item{reltol}{relative tolerance stopping criterion}

\item{maxiter}{maximum number of iterations}
}
\value{
a named list containing \describe{
\item{x}{a length-\eqn{n} solution vector}
\item{history}{dataframe recording iteration numerics. See the section for more details.}
}
}
\description{
Least Absolute Deviations (LAD) is an alternative to traditional Least Sqaures by using cost function
\deqn{\textrm{min}_x ~ \|Ax-b\|_1}
to use \eqn{\ell_1} norm instead of square loss for robust estimation of coefficient.
}
\section{Iteration History}{

When you run the algorithm, output returns not only the solution, but also the iteration history recording
following fields over iterates,
\describe{
\item{objval}{object (cost) function value}
\item{r_norm}{norm of primal residual}
\item{s_norm}{norm of dual residual}
\item{eps_pri}{feasibility tolerance for primal feasibility condition}
\item{eps_dual}{feasibility tolerance for dual feasibility condition}
}
In accordance with the paper, iteration stops when both \code{r_norm} and \code{s_norm} values
become smaller than \code{eps_pri} and \code{eps_dual}, respectively.
}

\examples{
\dontrun{
## generate data
m = 1000
n = 100
A = matrix(rnorm(m*n),nrow=m)
x = 10*matrix(rnorm(n))
b = A\%*\%x

## add impulsive noise to 10\% of positions
idx = sample(1:m, round(m/10))
b[idx] = b[idx] + 100*rnorm(length(idx))

## run the code
output = admm.lad(A,b)

## report convergence plot
niter  = length(output$history$s_norm)
par(mfrow=c(1,3))
plot(1:niter, output$history$objval, "b", main="cost function")
plot(1:niter, output$history$r_norm, "b", main="primal residual")
plot(1:niter, output$history$s_norm, "b", main="dual residual")
}


}
