% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{scSample}
\alias{scSample}
\title{Build groupSize pools according to cellIDs}
\usage{
scSample(
  RNAcounts,
  cellIDs = colnames(RNAcounts),
  groupSize = 3,
  randomize = TRUE
)
}
\arguments{
\item{RNAcounts}{The single cell matrix}

\item{cellIDs}{A vector will cell types for each column in scCountMatrix (DEFAULT: colnames(RNAcounts))}

\item{groupSize}{The number of sets to break it up into (DEFAULT: 3)}

\item{randomize}{Set to TRUE to randomize the sets (DEFAULT: TRUE)}
}
\value{
a list with a multiple sets
}
\description{
This function is intended to collapse many single cells into 3 (groupsize) groups
with the average count across all cells in each of the groups.  These groups can then be used to perform a 
t-test (for example) between the 3 groups of CellX with 3 groups of CellY
}
\examples{
RNAcounts <- matrix(0, nrow=10, ncol=100)
rownames(RNAcounts) <- make.names(rep('Gene', nrow(RNAcounts)), unique=TRUE)
colnames(RNAcounts) <- make.names(c('CellX', rep('CellY', 39), 
rep('CellZ', 30), rep('CellB', 30)), unique=TRUE)
RNAcounts[, grepl('CellY', colnames(RNAcounts))] <- 1
RNAcounts[, grepl('CellZ', colnames(RNAcounts))] <- 2
RNAcounts[, grepl('CellB', colnames(RNAcounts))] <- 3
scSample(RNAcounts, groupSize=3)

}
