% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\docType{data}
\name{vars_ph_p_sds_sum}
\alias{vars_ph_p_sds_sum}
\alias{compute_ph_p_sds_sum}
\title{Compute "Sleep Disturbance Scale [Parent] (Total): Sum [Validation: No
more than 0 missing or declined]"}
\format{
character vector of all column names
used to compute summary scores of \code{ph_p_sds_sum} and \code{ph_p_sds_nm}.
}
\usage{
vars_ph_p_sds_sum

compute_ph_p_sds_sum(
  data,
  name = "ph_p_sds_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score. \code{NULL} means no limit.}

\item{exclude}{character, Values to be excluded from the summary score.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_p_sds_sum}
Sleep Disturbance Scale [Parent] (Total): Sum [Validation: No more than 0
missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_p_sds__dims_001}
\item \code{ph_p_sds__dims_002}
\item \code{ph_p_sds__dims_003}
\item \code{ph_p_sds__dims_004}
\item \code{ph_p_sds__dims_005}
\item \code{ph_p_sds__swtd_001}
\item \code{ph_p_sds__swtd_002}
\item \code{ph_p_sds__swtd_003}
\item \code{ph_p_sds__hyphy_001}
\item \code{ph_p_sds__dims_006}
\item \code{ph_p_sds__dims_007}
\item \code{ph_p_sds__swtd_004}
\item \code{ph_p_sds__sbd_001}
\item \code{ph_p_sds__sbd_002}
\item \code{ph_p_sds__sbd_003}
\item \code{ph_p_sds__hyphy_002}
\item \code{ph_p_sds__da_001}
\item \code{ph_p_sds__swtd_005}
\item \code{ph_p_sds__swtd_006}
\item \code{ph_p_sds__da_002}
\item \code{ph_p_sds__da_003}
\item \code{ph_p_sds__does_001}
\item \code{ph_p_sds__does_002}
\item \code{ph_p_sds__does_003}
\item \code{ph_p_sds__does_004}
\item \code{ph_p_sds__does_005}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 items missing
}
}
\examples{
\dontrun{
compute_ph_p_sds_sum(data) |>
  select(
    all_of(c("ph_p_sds_sum", vars_ph_p_sds_sum))
  )
}
}
\keyword{datasets}
