% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MauchlyTest.R
\name{MauchlyTest}
\alias{MauchlyTest}
\title{Mauchly's Test for Sphericity (1 factor) v1.0}
\usage{
MauchlyTest(formula, data, alpha = 0.05, digits = 4, do_print = TRUE)
}
\arguments{
\item{formula}{Formula \code{dv ~ within | id}.}

\item{data}{\code{data.frame} with the variables.}

\item{alpha}{Significance level (default 0.05).}

\item{digits}{Decimals for printing (default 4).}

\item{do_print}{if \code{TRUE}, print a friendly summary.}
}
\value{
Objeto de clase \code{"sphericity"} with:
\describe{
  \item{Method}{Cadena con el método.}
  \item{Statistic}{Lista con \code{W} y \code{Chi2}.}
  \item{df}{Grados de libertad.}
  \item{p_value}{Valor-p.}
  \item{Decision}{\code{"Sphericity"} o \code{"No sphericity"} según \code{alpha}.}
  \item{Epsilons}{\code{GG} and \code{HF}.}
  \item{Components}{List with \code{n} (subjects), \code{k} (levels), \code{S} (covariances), \code{eigen} (eigenvalues).}
}
}
\description{
Tests for sphericity in repeated measures designs. Uses an interface for
type formula \code{dv ~ within | id}, where:
\itemize{
 \item \code{dv}: variable numerical response,
 \item \code{within}: within-subjects factor (repeated levels),
 \item \code{id}: subject/sample identifier.
}
}
\details{
Calculates Mauchly's statistic \eqn{W}, its approximation \eqn{W}
corrected, the p-value and the correction coefficients for lack of
sphericity (Greenhouse–Geisser y Huynh–Feldt).
}
\examples{
# Ejemplo mínimo (datos ficticios):
set.seed(1)
d <- data.frame(
  id = rep(1:10, each = 4),
  within = rep(paste0("t", 1:4), times = 10),
  y = as.numeric(rep(rnorm(10, 10, 2), each = 4)) +
      rep(c(0, .5, 1.2, .8), times = 10) + rnorm(40, 0, 1)
)
res <- MauchlyTest(y ~ within | id, data = d, do_print = TRUE)
summary(res)

}
\references{
Mauchly, J. W. (1940). Significance test for sphericity of a normal n-variate distribution. The Annals of Mathematical Statistics, 11(2), 204–209. https://doi.org/10.1214/aoms/1177731915
}
