% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{writeParameterObject}
\alias{writeParameterObject}
\title{Write Parameter Object to a File}
\usage{
writeParameterObject(parameter, file)
}
\arguments{
\item{parameter}{parameter on object created by \code{initializeParameterObject}.}

\item{file}{A filename that where the data will be stored.}
}
\value{
This function has no return value.
}
\description{
\code{writeParameterObject} will write the parameter object as binary to the filesystem
}
\details{
As Rcpp object are not serializable with the default R \code{save} function, 
therefore this custom save function is provided (see \link{loadParameterObject}).
}
\examples{
\dontrun{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")

## writing an empty parameter object as the runMCMC routine was not called yet
writeParameterObject(parameter = parameter, file = file.path(tempdir(), "file.Rda"))

}

}
