% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multibasicrules.R
\name{multibasicrules}
\alias{multibasicrules}
\title{Overview of the allocation rules}
\usage{
multibasicrules(
  c,
  rules = c("SFC", "SEC", "CEC", "CEB", "CP", "SM", "CC", "SIGMA", "PRIOR"),
  draw = TRUE,
  col = NULL,
  a = NULL,
  order = NULL,
  agents_names = NULL,
  labels = TRUE
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{rules}{A character vector specifying the allocation rules. The available rules are:
\code{"SFC"}, \code{"SEC"}, \code{"CEC"}, \code{"CP"}, \code{"CEB"}, \code{"SM"}, \code{"CC"}, \code{"SIGMA"} and \code{"PRIOR"}. By default, all the rules
are selected.}

\item{draw}{A logical value indicating whether or not the plot should be generated. By default, \code{draw = TRUE}.}

\item{col}{A vector that indicates the colors used to represent each agent in the graphical representation. By default,
the colors are selected by the function \code{rainbow()}.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule. It can only be defined when \code{"SIGMA"} is included in \code{rules}.
By default, \code{a = 0.5}.}

\item{order}{A numeric vector indicating the priority order of agents when making contributions. It can only be defined when \code{"PRIOR"} is included in \code{rules}.
By default, agents follow their original indexing and contribute accordingly.}

\item{agents_names}{A vector defining the name assigned to each agent. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the labels and the title of the plot should be displayed. By default, \code{labels = TRUE}.}
}
\value{
A data frame containing the contribution vectors determined by the selected allocation rules. Additionally, if \code{draw = TRUE},
a mosaic plot displaying the allocations obtained for the different rules.
}
\description{
\code{multibasicrules} calculates the contribution vectors resulting from the allocation of payments among different agents, applying various predefined rules.
It also generates a graphical representation of the allocations based on the implemented rules.
}
\details{
Let \eqn{X(c)} be the set of cost allocations for \eqn{c \in C^N}.
A rule is a mapping \eqn{\mathcal{R}: C^N \rightarrow \mathbb{R}^N} that associates with each problem a contribution vector \eqn{\mathcal{R}_P(c)} such that \eqn{0\leq\mathcal{R}_P(c)\leq c}. In other words, a rule is a mechanism that selects an allocation vector for each airport problem.

The various proposed rules, despite their differences, share a key characteristic: for any given problem,
each rule selects an allocation vector that belongs to its no-subsidy set.
Although these rules have been individually characterized in different functions, the one in question allows for the calculation of all of them at once.
}
\note{
When \code{"CC"} is included in the \code{rules} argument, the execution time of the function may significantly increase if the number of agents exceeds 150.
}
\examples{
# All rules with graphical representation
c <- c(1, 3, 7, 10) # Cost vector
multibasicrules(c)

# SEC, CEC and SIGMA rule without plot
c <- c(5, 10, 20) # Cost vector
multibasicrules(c, rules = c("SEC", "CEC", "SIGMA"), draw = FALSE, a = 0.75,
agents_names = c("Alex", "Estela", "Carmen"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Potters, J. and Sudhölter, P. (1999). Airport problems and consistent allocation rules.
\emph{Mathematical Social Sciences}, 38, 83–102.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{basicrule}}, \code{\link{comparisonallocations}}, \code{\link{plotallocations}}
}
