% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airportvector.R
\name{airportvector}
\alias{airportvector}
\title{Cost vector associated with an airport game}
\usage{
airportvector(v, lex = TRUE)
}
\arguments{
\item{v}{A numeric vector that represents the characteristic function of the airport game.}

\item{lex}{A logical value indicating the input order of the game. By default, if \code{lex = TRUE}, the game has been introduced in lexicographic order. However, if \code{lex = FALSE}, the game has been established in binary order.}
}
\value{
A numeric vector representing the cost for each agent of an airport game.
}
\description{
\code{airportvector} computes the cost vector corresponding to an airport problem.
}
\details{
A cooperative game \eqn{(N, v)} is considered an airport game provided that its characteristic function \eqn{v} satisfies:
\deqn{
v(S)=\text{max}\{c_j:j \in S\}, \quad \forall S \subseteq N,S \neq \emptyset
}
where \eqn{c_j} represents the individual cost associated with each agent \eqn{j}.

Evidently, this property implies that the cost assigned to a coalition is determined by the most expensive cost for its members.
It is for this reason that this class of games is always concave.

The airport game can be given in lexicographic order or binary order. For instance, if
\eqn{n=3}, the characteristic function of the associated airport game in lexicographic order is:
\deqn{
v=[v(\{1\}),v(\{2\}),v(\{3\}),v(\{1,2\}),v(\{1,3\}),v(\{2,3\}),v(\{1,2,3\})]
}
On the other hand, in binary order, it would be:
\deqn{
v=[v(\{1\}),v(\{2\}),v(\{1,2\}),v(\{3\}),v(\{1,3\}),v(\{2,3\}),v(\{1,2,3\})]
}
Anyway, in both cases, we have that \eqn{v(\{2\})=v(\{1,2\})} and \eqn{v(\{3\})=v(\{1,3\})=v(\{2,3\})=v(\{1,2,3\})}.

Given an airport game \eqn{(N, v)}, it is possible to extract the corresponding cost vector \eqn{c} by setting:
\deqn{
c_j=\text{min}\{v(S):j\in S \},\quad \text{for all} \quad j \in N.
}
}
\examples{
# 4 agents in lexicographic order
v <- c(1, 3, 7, 10, 3, 7, 10, 7, 10, 10, 7, 10, 10, 10, 10)
airportvector(v, lex = TRUE)

# 4 agents in binary order
u <- c(1, 3, 3, 7, 7, 7, 7, 10, 10, 10, 10, 10, 10, 10, 10)
airportvector(u, lex = FALSE)

}
\references{
Littlechild, S. C. and Owen, G. (1973). A simple expression for the Shapley value in a special case.
\emph{Management Science}, 23, 370-372.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{airportgame}}
}
