% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdTRW.R
\name{stdTRW}
\alias{stdTRW}
\title{stdTRW}
\usage{
stdTRW(inTRW)
}
\arguments{
\item{inTRW}{tibble. The first object resulting from the \code{TRW_readExcel} function.}
}
\value{
A tibble with the following columns: year, tree_code, TRW, meanTRW, and stdTRW.
Together with additional columns of grouping variables based on age class.
}
\description{
To remove the influences of local site characteristics on tree growth,
this function standardizes the tree-ring width series by dividing each
tree-ring width of a particular series by the mean width of that series.
In dendroclimatic studies, it is advisable to exclude the initial years
or decades of growth (the first “age bands”, i.e., 1-10 and 11-20) as
they are less likely to contain climatic signals rather than the influence
of strong early-year growth competition within the tree stand
(Mazza and Sarris, 2021; Sarris et al., 2007).
}
\details{
To export a tibble like the one below to an \code{.xlsx} file, you can use the \code{writexl} package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mytibble <- stdTRW_df |>
  dplyr::group_by(year) |>
  dplyr::summarise(
    N_trees = dplyr::n(),
    mean_stdTRW = mean(stdTRW, na.rm = TRUE)
  )

writexl::write_xlsx(mytibble, path = "my_stdTRW_df.xlsx")
}\if{html}{\out{</div>}}

This will create an Excel file named \code{my_stdTRW_df.xlsx} in your
current working directory. Please, check also the \strong{Examples} section
below for how to obtain \code{stdTRW_df} object.
}
\examples{
inTRW_1 <- inTRW[[1]]

stdTRW_df <- stdTRW(inTRW_1)

stdTRW_df |>
dplyr::group_by(year) |>
dplyr::summarise(N_trees = dplyr::n(),
       mean_stdTRW = mean(stdTRW, na.rm = TRUE)) |>
       ggplot2::ggplot(ggplot2::aes(year, N_trees)) +
       ggplot2::geom_line()
}
\references{
Mazza, G., Sarris, D., 2021. Identifying the full spectrum of climatic
signals controlling a tree species' growth and adaptation to climate change.
Ecol. Indic. 130, 108109. https://doi.org/10.1016/j.ecolind.2021.108109.

Sarris, D., Christodoulakis, D., Körner, C., 2007. Recent decline in precipitation
and tree growth in the eastern Mediterranean.
Glob. Chang. Biol. 13 (6), 1187–1200. https://doi.org/10.1111/j.1365-2486.2007.01348.x.
}
\seealso{
\code{\link{TRW_readExcel}}, \code{\link{ABD}}

Other ABD functions: 
\code{\link{ABD}()},
\code{\link{TRW_readExcel}()}
}
\concept{ABD functions}
