% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{nonlinear_langmuir}
\alias{nonlinear_langmuir}
\title{Non-linear Langmuir Model}
\usage{
nonlinear_langmuir(Ce, Qe)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}
}
\value{
A named list of Langmuir parameters and model details, including estimated parameters, model statistics, and a diagnostic plot.
}
\description{
The non-linear Langmuir isotherm model describes monolayer adsorption onto a surface with a finite number of identical sites.
It assumes uniform adsorption energies and no interaction between adsorbed molecules.

The model is defined as:

\deqn{Q = \frac{Q_{\max} \cdot K_L \cdot C_e}{1 + K_L \cdot C_e}}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{Q_{\max}} is the maximum adsorption capacity, and \eqn{K_L} is the Langmuir constant.

This function fits the model using non-linear least squares (nls) regression.
}
\examples{
Ce <- c(1, 2, 4, 6, 8, 10)
Qe <- c(0.9, 1.6, 2.3, 2.7, 2.9, 3.0)
result <- nonlinear_langmuir(Ce, Qe)
print(result$`Langmuir Qmax (mg/g)`)
print(result$`Langmuir KL (L/mg)`)
print(result$AIC)
print(result$`Pseudo R2`)
print(result$Plot)
}
\seealso{
Other nonlinear models: \code{\link{nonlinear_bet}()}, \code{\link{nonlinear_freundlich}()}, \code{\link{nonlinear_temkin}()}
}
\concept{nonlinear}

