% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{kinesis_get_records}
\alias{kinesis_get_records}
\title{Get record from a Kinesis Stream}
\usage{
kinesis_get_records(
  stream,
  region = "us-west-1",
  limit = 25,
  shard_id,
  iterator_type = c("TRIM_HORIZON", "LATEST", "AT_SEQUENCE_NUMBER",
    "AFTER_SEQUENCE_NUMBER", "AT_TIMESTAMP"),
  start_sequence_number,
  start_timestamp
)
}
\arguments{
\item{stream}{stream name (string)}

\item{region}{AWS region (string)}

\item{limit}{number of records to fetch}

\item{shard_id}{optional shard id - will pick a random active shard if left empty}

\item{iterator_type}{shard iterator type}

\item{start_sequence_number}{for \code{AT_SEQUENCE_NUMBER} and \code{AFTER_SEQUENCE_NUMBER} iterators}

\item{start_timestamp}{for \code{AT_TIMESTAMP} iterator}
}
\value{
character vector that you might want to post-process eg with \code{jsonlite::stream_in}
}
\description{
Get record from a Kinesis Stream
}
\note{
Use this no more than getting sample data from a stream - it's not intended for prod usage.
}
\references{
\url{https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/kinesis/model/GetRecordsRequest.html}
}
