% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat14}
\alias{simDat14}
\title{Simulate data for Chapter 14: Poisson GLMM}
\usage{
simDat14(
  nPops = 16,
  nYears = 30,
  mu.alpha = 3,
  sigma.alpha = 1,
  mu.beta = -2,
  sigma.beta = 0.6
)
}
\arguments{
\item{nPops}{Number of populations}

\item{nYears}{Number of years sampled in each population}

\item{mu.alpha}{Mean of random intercepts}

\item{sigma.alpha}{SD of random intercepts}

\item{mu.beta}{Mean of random slopes}

\item{sigma.beta}{SD of random slopes}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nYears}{Number of years sampled}
  \item{mu.alpha}{Mean of random intercepts}
  \item{sigma.alpha}{SD of random intercepts}
  \item{mu.beta}{Mean of random slopes}
  \item{sigma.beta}{SD of random slopes}
  \item{pop}{Population index}
  \item{orig.year}{Year values, non-scaled}
  \item{year}{Year values, scaled to be between 0 and 1}
  \item{alpha}{Random intercepts}
  \item{beta}{Random slopes}
  \item{C}{Simulated shrike counts}
}
\description{
Simulate count ~ year regressions in 16 populations of red-backed shrikes
}
\examples{
library(lattice)
str(dat <- simDat14())
xyplot(dat$C ~ dat$orig.year | dat$pop, ylab = "Red-backed shrike counts", xlab = "Year", pch = 16,
       cex = 1.2, col = rgb(0, 0, 0, 0.4), 
       main = 'Realized population trends\n(random-coefficients model)') # works

# Revert to random intercept model. Increased sigma.alpha to emphasize the random intercepts part
str(dat <- simDat14(nPops = 16, sigma.alpha = 1, sigma.beta = 0))
xyplot(dat$C ~ dat$orig.year | dat$pop, ylab = "Red-backed shrike counts", xlab = "Year",
       pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4), 
       main = 'Realized population trends (random-intercepts model)')

# Revert to random-effects one-way Poisson ANOVA model: random intercepts, but zero slopes
str(dat <- simDat14(nPops = 16, sigma.alpha = 1, mu.beta = 0, sigma.beta = 0))
xyplot(dat$C ~ dat$orig.year | dat$pop, ylab = "Red-backed shrike counts", xlab = "Year",
       pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4), 
       main = 'Realized population trends
       (random-effects, one-way Poisson ANOVA model)')

# Revert to simple log-linear Poisson regression (no effects of pop on intercepts or slopes)
str(dat <- simDat14(nPops = 16, sigma.alpha = 0, sigma.beta = 0))
xyplot(dat$C ~ dat$orig.year | dat$pop, ylab = "Red-backed shrike counts", 
       xlab = "Year", pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4), 
       main = 'Realized population trends\n(simple log-linear Poisson regression)')

# Revert to Poisson "model-of-the-mean": no effects of either population or body length
str(dat <- simDat14(nPops = 16, sigma.alpha = 0, mu.beta = 0, sigma.beta = 0))
xyplot(dat$C ~ dat$orig.year | dat$pop, ylab = "Red-backed shrike counts", 
       xlab = "Year", pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4), 
       main = 'Realized population trends\n(Poisson "model-of-the-mean")')

}
\author{
Marc Kéry
}
