% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQuadtree-class.R
\docType{class}
\name{AQuadtree-class}
\alias{AQuadtree-class}
\alias{AQuadtree}
\title{Class "AQuadtree".}
\usage{
AQuadtree(
  points,
  dim = 1000,
  layers = 5,
  colnames = NULL,
  threshold = 100,
  thresholdField = NULL,
  funs = NULL,
  ineq.threshold = 0.25,
  loss.threshold = 0.4
)
}
\arguments{
\item{points}{object of class "SpatialPoints" or "SpatialPointsDataFrame".}

\item{dim}{a single integer specifying the initial cell sizes in meters, defaults to 1000.}

\item{layers}{a single integer specifying the number of divisions of the
initial cells, defaults to 5.}

\item{colnames}{character string or character string vector specifying the
columns to summarise in the resulting quadtree.}

\item{threshold}{number. The threshold minimum value each cell must have
in the column \code{thresholdField}.}

\item{thresholdField}{character string specifying the column at which the
\code{threshold} value will apply.}

\item{funs}{character string or character string vector specifying the summary
functions for each of the \code{colnames}. If vector, the size must be the
same as colnames.}

\item{ineq.threshold}{inequality threshold value to be considered on the
disaggregation process. Forces disaggregation under the given inequality
threshold.}

\item{loss.threshold}{loss threshold value to be considered on the
disaggregation process. Forces aggregation when there's much loss
(i.e loss rate > ineq.threshold ).}
}
\value{
AQuadtree object representing a varying size Quadtree
aggregation for the given points.
}
\description{
An S4 class representing a Quadtree hierarchical geographic Grid
to anonymise spatial point data.

Objects can be created by calls to the function \link{AQuadtree}

Wrapper function AQuadtree.
}
\details{
Given a set of points, the \code{AQuadtree class} represents a
varying size Quadtree grid created performing a
bottom-up aggregation considering a minimum threshold for each cell.
Cells with a value under the threshold for the \code{thresholdField} are
aggregated to the upper level in a quadtree manner.\cr
When no \code{thresholdField} is given, total number  of points in the cell
will be used, and so, given a threshold of k, none of the cells in the
resulting grid have a value less than k individuals as in a k-anonymity model.\cr
The Quadtree produced balances information loss and accuracy. For instance,
for the set of cells in the left image, where numbers in the cells represent
the values in the \code{thresholdField}, using a \code{threshold} value of 100,
the resulting Quadtree will be the one on the right. As we can see, some cells
will be discarded, and some aggregated to maintain as much information as
possible, keeping at the same time as much disaggregation as possible\cr
\if{html}{\figure{QTexampleA.png}{options: width=260 alt="62.5m2 cells"}}
\if{latex}{\figure{QTexampleA.png}{options: width=4.5cm}}
\if{html}{\figure{QTexampleB.png}{options: width=250 alt="resulting Quadtree"}}
\if{latex}{\figure{QTexampleB.png}{options: width=4.4cm}}\cr
The INSPIRE coding system for cell identifiers will be used to generate a
CellCode and CellNum for each cell in the Quadtree.
The objective of the coding system is to generate unique
identifiers for each cell, for any of the resolutions.\cr
The cellCode is a text string, composed of cell size and cell coordinates.
Cell codes start with a cell size prefix. The cell size is denoted in meter (m)
for cell sizes below 1000 m and kilometre (km) for cell sizes from 1000 m and
above.\cr
Example: a 100 meter cell has an identifier starting with “100m”, the
identifier  of a 10000 meter cell starts with “10km”.\cr
The coordinate part of the cell code reflects the distance of the lower left
grid cell corner from the false origin of the CRS. In order to reduce the
length of the string, Easting (E) and Northing (N) values are divided by
10^n (n is the number of zeros in the cell size value). Example for a cell
size of 10000 meters: The number of zeros in the cell size value is 4.
The resulting divider for Easting and Northing values is 10^4 = 10000.\cr
The CellNum is a sequence of concatenated integers identifying all the
hierarchical partitions of the main cell in which the point resides.
For instance, the CellNum of the top right cell would be 416 (fourth
in first partition, sixteenth in second partition)\cr
The input object must be projected and units should be in 'meters'
because the system uses the INSPIRE coding system.

function to create an object of class AQuadtree
}
\section{Slots}{

\describe{
\item{\code{dim}}{= "numeric"}

\item{\code{layers}}{= "numeric",}

\item{\code{colnames}}{= "character",}

\item{\code{threshold}}{= "numeric",}

\item{\code{thresholdField}}{= "character",}

\item{\code{loss}}{= "numeric"}
}}

\examples{
data("BarcelonaPop", "BarcelonaCensusTracts")
aquadtree.Barcelona<-AQuadtree(BarcelonaPop, layers = 3)
plot(aquadtree.Barcelona)

aQuadtree.Charleston<-AQuadtree(CharlestonPop, colnames="sex", threshold=17,
  thresholdField=c("sex.male", "sex.female"))

\dontrun{
## spatial object not projected
sp.not.projected<-spTransform(CharlestonPop,CRS("+proj=longlat +datum=NAD27"))
is.projected(sp.not.projected)
aqt<-AQuadtree(sp.not.projected)

## not an SpatialPoints object
aqt<-AQuadtree(CharlestonCensusTracts)

## too many subdivisions
aqt<-AQuadtree(CharlestonPop, layers=15)

}
}
\seealso{
\itemize{
  \item{
   INSPIRE Data Specification on Geographical Grid Systems – Technical Guidelines
   \url{https://knowledge-base.inspire.ec.europa.eu/publications/inspire-data-specification-geographical-grid-systems-technical-guidelines_en}
  }
  \item{
   EEA reference grid dataset
   \url{https://data.europa.eu/euodp/data/dataset/data_eea-reference-grids-2}
  }
}
}
