% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALLSPICE.R
\name{ALLSPICE_simulation}
\alias{ALLSPICE_simulation}
\title{ALLSPICE_simulation}
\usage{
ALLSPICE_simulation(n_ind, n_var, c, r, pi, sigma, mle = TRUE, null = TRUE)
}
\arguments{
\item{n_ind}{total number of individuals}

\item{n_var}{total number of variants}

\item{c}{slope between the two sets of variant effect sizes, only applicable when `null` == TRUE}

\item{r}{phenotypic correlation between the two phenotypes}

\item{pi}{probability of variant of having no effect on the phenotype}

\item{sigma}{variance of the two sets of effect sizes}

\item{mle}{whether to use MLE of c to compute the test statistic, use true c value if FALSE}

\item{null}{whether to simulate data under the null hypothesis (no linear relationship) or the alternative hypothesis}
}
\value{
A list of two pieces of results:
1) ALLSPICE test results
2) effect size table: true effect size simulated, effect size estimate from linear model, effect size estimated from MLE
}
\description{
Simulate data and run ALLSPICE
}
\examples{
ALLSPICE_simulation(n_ind=10000, n_var=100, c=0.6, r=0.5, pi=0.5, sigma=1, mle = TRUE, null=TRUE)

}
