% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctUndercalledHets.R
\name{correctUndercalledHets}
\alias{correctUndercalledHets}
\title{Correct undercalled heterozygous sites based on flanking alleles.}
\usage{
correctUndercalledHets(inputGenos = "genotypes", maxHapLength = 1)
}
\arguments{
\item{inputGenos}{A genotypes list object.}

\item{maxHapLength}{The maximum length of not heterozygous stretches flanked
by heterzygous sites that are changed to heterozygous. If set to 1
(default) only HAH or HBH will be corrected. If set to 2, both HAH and HAAH
(or HBH and HBBH) will be corrected.}
}
\value{
A genotype object in which undercalled heterozygous sites are
  corrected if both flanking alleles match.
}
\description{
Correct undercalled heterozygous sites based on flanking alleles.
}
\examples{
\dontrun{corrUndHetsGenos <- correctUndercalledHets(genotypes, maxHapLength = 3)}
}

