% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_data.R
\name{overlap_data}
\alias{overlap_data}
\title{Overlapping Student's t-test and delta beta results}
\usage{
overlap_data(x, y)
}
\arguments{
\item{x}{Results from t-test or delta beta analyses}

\item{y}{Results from t-test or delta beta analyses}
}
\description{
This function overlaps the results from both Student’s t-test and delta beta analyses to identify probes (CpG sites) that are highly and significantly different between cases and controls.
}
\examples{
\donttest{
data(test_data)
data(nonspecific_probes)
data(annotation_file)
test_data_filtered <- filter_data(test_data)
test_data_ttest <- ttest_data(test_data_filtered, 1, 2, 3, 4, 1e-3)
test_data_delta_beta <- delta_beta_data(test_data_filtered, 1, 2, 3, 4, 0.5, -0.5, 0.94, 0.06)
test_overlapped_data <- overlap_data(test_data_ttest, test_data_delta_beta)
}
}

