% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.zoomly.R
\name{as.zoomly}
\alias{as.zoomly}
\alias{as.zoomly.zoocat}
\title{Coercion objects to class \code{zoomly}}
\usage{
as.zoomly(x, ...)

\method{as.zoomly}{zoocat}(x, ...)
}
\arguments{
\item{x}{an object.}

\item{...}{further arguments passed to methods.}
}
\value{
A "\code{zoomly}" object.
}
\description{
Coercion objects to class "\code{zoomly}". The index name of the object will be set to "year".
}
\examples{
x <-  matrix(1 : 36, nrow = 3)
zc <- zoocat(x, order.by = 1991 : 1993, 
             colattr = data.frame(month = 1 : 12))
as.zoomly(zc)
             

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xx', 3), 'yy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
as.zoomly(zc)

}

