% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlib.R
\name{decompress}
\alias{decompress}
\title{Single-step decompression of raw data}
\usage{
decompress(data, wbits = 0)
}
\arguments{
\item{data}{Compressed raw data to be decompressed.}

\item{wbits}{The window size bits parameter. Default is 0.}
}
\value{
A raw vector containing the decompressed data.
}
\description{
Decompresses the provided compressed raw data in a single step.
}
\details{
The \code{decompress} function offers a streamlined approach to decompressing
raw data. By abstracting the creation of a decompression object, decompressing
the data, and flushing the buffer into one function call, it provides a hassle-free
way to retrieve original data from its compressed form. This function is designed
to work seamlessly with data compressed using the \code{compress} function or
any other zlib-based compression method.
}
\examples{
original_data <- charToRaw("some data")
compressed_data <- compress(original_data)
decompressed_data <- decompress(compressed_data)

}
