% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{connect_pairs}
\alias{connect_pairs}
\title{Connecting Possibly Overlapping Pairs Into a List of Paths}
\usage{
connect_pairs(x, duplicate.rm = FALSE)
}
\arguments{
\item{x}{two-column \code{\link{matrix}}, \code{\link{data.frame}}, or
a \code{\link{list}} containing vectors of length two representing
the pairs to be connected.}

\item{duplicate.rm}{\code{\link{logical}} indicating whether equal
pairs (up to permutation) are to be omitted.}
}
\value{
A \code{\link{list}} each of whose elements give a path of connected pairs. 
Each list element is a vector of length at least 2 
(longer vectors > 2 in length identify the pairs connected in a path).
}
\description{
Pairs, given as rows of a \code{\link{matrix}},  
\code{\link{data.frame}}, or \code{\link{list}}, are processed to return
a list of paths, each identifying the connected pairs in the rows of \code{x}.
}
\examples{
## First something simple.  
(pairs <- matrix(c(1,2,2,3,3,5,5,7,8,9), ncol = 2, byrow = TRUE))
## Connect pairs into separate paths defined by the row order.
connect_pairs(pairs)

## Now something different
nVars <- 5
pairs <- expand.grid(1:nVars, 1:nVars)
## and take those where
(pairs <- pairs[pairs[,1] < pairs[,2],])
connect_pairs(pairs)

## Something more complicated. 
## Get weights
set.seed(27135)
x <- runif(choose(nVars,2)) # weights

## We imagine pairs identify edges of a graph with these weights
## Get a zenpath ordering the edges based on weights 
(zp <- zenpath(x, pairs = pairs, method = "strictly.weighted"))

## And connect these giving the list of paths
connect_pairs(zp)

}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: \code{\link{extract_pairs}},
  \code{\link{graph_pairs}}, \code{\link{groupData}},
  \code{\link{indexData}}, \code{\link{zenpath}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
