% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_prob.R
\name{estimate_prob}
\alias{estimate_prob}
\title{Estimate marginal and multivariate probabilities}
\usage{
estimate_prob(x)
}
\arguments{
\item{x}{data.frame or matrix.}
}
\value{
List containing the following values:
  \itemize{
  \item margins: a list of marginal probabilities. Names correspond to colnames(x).
  \item observed: observed multivariate probability array.
  \item expected: expected multivariate probability array
  }
}
\description{
Maximum-likelihood estimation of marginal and multivariate observed and expected independence probabilities. Marginal probability refers to probability of each factor per individual column. Multivariate probability refer to cross-classifying factors for all columns.
}
\examples{
# This is what happens behind the curtains in the 'lassie' function
# Here we compute the association between the 'Girth' and 'Height' variables
# of the 'trees' dataset

# 'select' and 'continuous' take column numbers or names
select <- c('Girth', 'Height') # select subset of trees
continuous <-c(1, 2) # both 'Girth' and 'Height' are continuous

# equal-width discretization with 3 bins
breaks <- 3

# Preprocess data: subset, discretize and remove missing data
pre <- preprocess(trees, select, continuous, breaks)

# Estimates marginal and multivariate probabilities from preprocessed data.frame
prob <- estimate_prob(pre$pp)

# Computes local and global association using Ducher's Z
lam <- local_association(prob, measure = 'z')
}

