% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBatsmenPartnershipOppnAllMatchesChart.R
\name{teamBatsmenPartnershipOppnAllMatchesChart}
\alias{teamBatsmenPartnershipOppnAllMatchesChart}
\title{Plot of team partnership all matches against an opposition}
\usage{
teamBatsmenPartnershipOppnAllMatchesChart(matches,main,opposition, plot=TRUE)
}
\arguments{
\item{matches}{All the matches of the team against all oppositions}

\item{main}{The main team for which the the batting partnerships are sought}

\item{opposition}{The opposition team for which the the batting partnerships are sought}

\item{plot}{Whether the partnerships have top be rendered as a plot. If plot=FALSE the data frame is returned}
}
\value{
None or partnerships
}
\description{
This function plots  the batting partnership of a team againt all oppositions in all matches
This function also returns a  dataframe  with the batting partnerships
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India against all oppositions
d <- teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,"India",rank=1,dispRows=50)
 #Plot the partnerships
teamBatsmenVsBowlersAllOppnAllMatchesPlot(d)

#Do not plot but get the dataframe
e <- teamBatsmenVsBowlersAllOppnAllMatchesPlot(d,plot=FALSE)
}

}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenVsBowlersOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
