% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlingPerfOppnAllMatches.R
\name{teamBowlingPerfOppnAllMatches}
\alias{teamBowlingPerfOppnAllMatches}
\title{team bowling performance all matches against an opposition}
\usage{
teamBowlingPerfOppnAllMatches(matches,main,opposition)
}
\arguments{
\item{matches}{The matches of the team against an opposition.}

\item{main}{Team for which bowling performance is required}

\item{opposition}{The opposition Team}
}
\value{
l
A data frame with the bowling performance
}
\description{
This function computes returns the bowling dataframe of bowlers deliveries, maidens, overs, wickets
against an opposition in all matches
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get all matches between India and Autralia
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

# Or load directly from saved file
# load("India-Australia-allMatches.RData")

teamBowlingPerfOppnAllMatches(matches,"India","Australia")
teamBowlingPerfOppnAllMatches(matches,main="Australia",opposition="India")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBowlersWicketsOppnAllMatches}}\cr
\code{\link{teamBowlersWicketRunsOppnAllMatches}}\cr
\code{\link{teamBowlersWicketKindOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
