% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desolve.R
\name{desolve.dvec}
\alias{desolve.dvec}
\title{Desolve Guide for Decorated Vector}
\usage{
\method{desolve}{dvec}(x, ...)
}
\arguments{
\item{x}{}

\item{...}{passed to \code{\link{drop_title}}, \code{\link{unclassified}}, and \code{\link{implicit_guide}}}
}
\value{
dvec
}
\description{
Un-resolves explicit usage of default key 'guide' to
implicit usage for class dvec.
Calls 
\code{\link{drop_title}},
\code{\link{unclassified}},
and \code{\link{implicit_guide}}.
}
\examples{
library(magrittr)
x <- as_dvec(4:6)
attr(x, 'guide') <- 'kg'
x \%>\% str
x \%>\% resolve \%>\% str
x \%>\% resolve \%>\% desolve \%>\% str
}
\seealso{
Other resolve: 
\code{\link{desolve}()},
\code{\link{desolve.classified}()},
\code{\link{desolve.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{resolve}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.data.frame}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.dvec}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{resolve}
\keyword{internal}
