% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_csv.R
\name{io_csv}
\alias{io_csv}
\title{Import and Export Documented Tables as CSV}
\usage{
io_csv(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
See methods.
}
\description{
Imports or exports documented tables as comma-separated variable.
Generic, with methods that extend \code{\link[csv]{as.csv}}.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
out <- file.path(tempdir(), 'out.csv')
foo <- io_csv(x, out)
identical(out, foo)
y <- io_csv(foo)
attr(x, 'source') <- NULL
attr(y, 'source') <- NULL
identical(x, y) # lossless 'round-trip'
}
\seealso{
Other io: 
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()}
}
\concept{io}
