% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularity.R
\name{singularity}
\alias{singularity}
\title{Choose Singular Expression}
\usage{
singularity(x, data, ...)
}
\arguments{
\item{x}{list of expressions}

\item{data}{something coercible to a data environment (typically data.frame)}

\item{...}{ignored}
}
\value{
integer, possibly NA
}
\description{
For a list of expressions evaluated within data,
this returns the index of the one expression that evaluates
to an all-true vector (after coercing NA to FALSE).
Returns 0 if no expressions succeed, and NA_integer_ if
more than one succeed. Returns -1 if any expression
does not evaluate to logical or if list is empty.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- read.csv(meta)
singularity(
  data = x,
  list(
    "event == 'conc'",
    "event == 'dose'",
    "event == 'metabolite'"
  )
)
singularity(
  data = x[x$event == 'dose',],
  list(
    "event == 'conc'",
    "event == 'dose'",
    "event == 'metabolite'"
  )
)
singularity(
  data = x[x$event == 'dose',],
  list(
    "time >= 0",
    "event == 'dose'"
  )
)
}
\seealso{
Other promote: 
\code{\link{[.decorated}()},
\code{\link{filter.decorated}()},
\code{\link{promote.data.frame}()},
\code{\link{promote.list}()},
\code{\link{promote}()}
}
\concept{promote}
\keyword{internal}
