% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dput_addins.R
\name{dputSelectedAddin}
\alias{dputSelectedAddin}
\title{Replaces selected code with its dput() output}
\usage{
dputSelectedAddin(selection = NULL, insert = TRUE, indentation = 0)
}
\arguments{
\item{selection}{String of code. (Character)

E.g. \code{"stop('This gives an expect_error test')"}.

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{insert}{Whether to insert the expectations via
\code{\link[rstudioapi:rstudio-documents]{rstudioapi::insertText()}}
or return them. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{indentation}{Indentation of the selection. (Numeric)

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Inserts the output of running
\code{\link[base:dput]{dput()}} on the selected code.

Does not return anything.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

RStudio Addin:
Runs \code{\link[base:dput]{dput()}} on the selected code and inserts
it instead of the selection.

See \code{`Details`} for how to set a key command.
}
\details{
\subsection{How}{
Parses and evaluates the selected code string,
applies \code{\link[base:dput]{dput()}} and
inserts the output instead of the selection.
}
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"dput() Selected"} and press its field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+D}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other addins: 
\code{\link{assertCollectionAddin}()},
\code{\link{initializeGXSFunctionAddin}()},
\code{\link{initializeTestthatAddin}()},
\code{\link{insertExpectationsAddin}()},
\code{\link{navigateTestFileAddin}()},
\code{\link{wrapStringAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
