% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_gxs_function_addin.R
\name{initializeGXSFunctionAddin}
\alias{initializeGXSFunctionAddin}
\title{Initialize \code{gxs_function()} call}
\usage{
initializeGXSFunctionAddin(selection = NULL, insert = TRUE, indentation = 0)
}
\arguments{
\item{selection}{Name of function to test with gxs_function. (Character)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{insert}{Whether to insert the code via
\code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}
or return them. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{indentation}{Indentation of the selection. (Numeric)

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Inserts \code{\link[xpectr:gxs_function]{gxs_function()}} call for
the selected function.

Returns \code{NULL} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Initializes the \code{gxs_function()} call with the arguments and default values
of the selected function.

See \code{Details} for how to set a key command.
}
\details{
\subsection{How}{
Parses and evaluates the selected code string
within the parent environment.
When the output is a function, it extracts the formals (arguments and default values)
and creates the initial \code{args_values} for \code{\link[xpectr:gxs_function]{gxs_function()}}.
When the output is not a function, it throws an error.
}
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"Initialize gxs_function()"} and press its field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+F}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other expectation generators: 
\code{\link{gxs_function}()},
\code{\link{gxs_selection}()},
\code{\link{insertExpectationsAddin}()}

Other addins: 
\code{\link{assertCollectionAddin}()},
\code{\link{dputSelectedAddin}()},
\code{\link{initializeTestthatAddin}()},
\code{\link{insertExpectationsAddin}()},
\code{\link{navigateTestFileAddin}()},
\code{\link{wrapStringAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
\concept{expectation generators}
