% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_categories.R
\name{set_categories}
\alias{set_categories}
\title{set_categories}
\usage{
set_categories(py_obj, labels)
}
\arguments{
\item{py_obj}{py_obj}

\item{labels}{labels}
}
\value{
An openpyxl Python object.
}
\description{
Set the categories / x-axis values
}
\examples{
\dontrun{
wb <- Workbook()
ws <- active(wb)

chart1 <- BarChart(
  type = "col",
 style = 10,
  title = "Bar Chart",
  shape = 4
) |>
  y_axis(title = "Test number") |>
  x_axis(title = "Sample length (mm)")

data <- Reference(ws, min_col=2, min_row=1, max_row=7, max_col=3)
cats <- Reference(ws, min_col=1, min_row=2, max_row=7)

chart1 |>
  add_data(data = data, titles_from_data = TRUE) |>
  set_categories(cats)
}

}
