% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_annotate_status_png.R
\name{xgx_annotate_status_png}
\alias{xgx_annotate_status_png}
\title{Annotate a png file or directory of png files}
\usage{
xgx_annotate_status_png(
  file_or_dir,
  script = "",
  status = "DRAFT",
  date_format = "\%a \%b \%d \%X \%Y",
  col = grDevices::grey(0.8, alpha = 0.7),
  font = 2,
  cex_status_mult = 7,
  cex_footnote_mult = 0.8,
  status_angle = 45,
  x11 = FALSE
)
}
\arguments{
\item{file_or_dir}{The png file to annotate or directory location for
annotating png files.  Note this will annotate just once, so if
you generate multiple png files and then annotate at the end of
your script it will have the correct script name on it. Then if
you create new images in a different script in the same directory
and then annotate with the script name the second script, the PNG
files will show the correct script location for each file.}

\item{script}{Script name to add as a footnote; By default this is
empty, though it could name the script that}

\item{status}{Draft or other status; If \code{status="Final"} or
\code{status=""} the status overlay will be removed.  By default
the status is DRAFT.}

\item{date_format}{Date format for adding the time the png was
annotated.}

\item{col}{Color for annotating the draft status}

\item{font}{Font to use for the annotation function}

\item{cex_status_mult}{Multiplication factor for the status
annotation.  By default 7}

\item{cex_footnote_mult}{Multiplication factor for the footnote
annotation. By default 0.8}

\item{status_angle}{Angle to rotate status}

\item{x11}{Display on the X11/Windows device}
}
\value{
nothing
}
\description{
These function annotates a single png file or all files within a
directory.
}
\details{
If a png file has been annotated once, this function will not
annotate it again.  Therefore, you can run this function on
directories with different input script names and it will label
each file based on when each file was run.

Based on code from MrFlick on
\href{https://stackoverflow.com/a/23816416}{Stack Overflow}.
}
\examples{
# using the examples from plot()
file.name <- tempfile()
grDevices::png(file.name)
graphics::plot(cars)
graphics::lines(stats::lowess(cars))
grDevices::dev.off()
# annotate one file
xgx_annotate_status_png(file.name, "/tmp/script1.R")

}
\author{
Matthew Fidler, Alison M, ....
}
