% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sad}
\alias{sad}
\title{Single Ascending Dose Data Set}
\format{A data frame with the following 16 columns:
\tabular{rll}{
  column 1: \tab \code{ID} \tab numeric; unique subject ID\cr
  column 2: \tab \code{TIME} \tab numeric; time relative to first drug 
  administration\cr
  column 3: \tab \code{NOMTIME} \tab numeric; nominal time\cr
  column 4: \tab \code{TIMEUNIT} \tab character; unit of TIME\cr
  column 5: \tab \code{AMT} \tab numeric; dosing amount (for dosing events) 
  in mg\cr
  column 6: \tab \code{LIDV} \tab numeric; observation on a linear scale 
  (observation type determined by CMT), units determined by EVENTU column\cr
  column 7: \tab \code{MDV} \tab numeric; missing dependent variable \cr
  (1 if missing, 0 otherwise)\cr
  column 8: \tab \code{CMT} \tab integer; compartment number 
  (determines observation type):\cr
  \tab \tab CMT 1 = Dosing event\cr
  \tab \tab CMT 2 = PK concentration\cr
  column 9: \tab \code{NAME} \tab character; description of event\cr
  column 10: \tab \code{EVENTU} \tab character; unit for observation\cr
  column 11: \tab \code{CENS} \tab integer; censored values
  (0 = not censored, 1 = censored)\cr
  column 12: \tab \code{EVID} \tab integer; event ID (0 = observation, 
  1 = dosing event)\cr
  column 13: \tab \code{WEIGHTB} \tab numeric; baseline body weight (kg)\cr
  column 14: \tab \code{SEX} \tab character; sex\cr
  column 15: \tab \code{TRTACT} \tab factor; treatment group label\cr
  column 16: \tab \code{DOSE} \tab numeric; randomized dose in mg 
  received
}}
\usage{
sad
}
\description{
Model generated PK data to mimic an orally administered small molecule.
Simulated single dose administration ranging from 100 mg to 1600 mg.
}
\keyword{datasets}
