% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminate.R
\name{terminateLEQ}
\alias{terminateLEQ}
\title{Terminates, if the solution is less equal a threshold.}
\usage{
terminateLEQ(solution, lF)
}
\arguments{
\item{solution}{A named list with at least the following elements:
$name, $fitness, $value, $numberOfSolutions, 
$genotype, $phenotype, $phenotypeValue.}

\item{lF}{Local function configuration. It must contain
\itemize{
\item \code{lF$TerminationThreshold()} which returns 
      a numeric value.
}}
}
\value{
Boolean.
}
\description{
\code{terminateLEQ()} 
returns \code{TRUE} if the value of the current solution 
is less or equal \code{lF$TerminationThreshold()}.
}
\examples{
    parm<-function(x){function() {return(x)}}
    lF<-list(); lF$TerminationThreshold<-parm(9.2)
    solution<-list(); solution$phenotypeValue<-8.0
    terminateLEQ(solution, lF)
    solution<-list(); solution$phenotypeValue<-9.6
    terminateLEQ(solution, lF)
}
\seealso{
Other Termination Condition: 
\code{\link{terminateAbsoluteError}()},
\code{\link{terminateGEQ}()},
\code{\link{terminatePAC}()},
\code{\link{terminateRelativeError}()},
\code{\link{terminateRelativeErrorZero}()},
\code{\link{terminatedFalse}()}
}
\concept{Termination Condition}
