
#' Genetic operations for permutation genes.
#' 
#' Permutation genes are  a representation of a tour of a 
#' Traveling Salesman Problem (TSP).
#'
#' For permutation genes, the \code{xegaPermGene} package provides
#' \itemize{
#' \item Gene initiatilization.
#' \item Decoding of parameters.
#' \item Mutation functions as well as a function factory for configuration.
#' \item Crossover functions as well as a function factory for configuration.
#' }
#' 
#' @section Permutation Gene Representation:
#'            
#' A permutation gene is a named list with at least the following elements:
#'   \itemize{
#'    \item \code{$gene1}:      The gene must be a permutation vector.
#'    \item \code{$fit}:        The fitness value of the gene
#'                      (for EvalGeneDet and EvalGeneU) or
#'                      the mean fitness (for stochastic functions
#'                      evaluated with EvalGeneStoch).
#'    \item \code{$evaluated}:  Boolean. Has the gene been evaluated?
#'    \item \code{$evalFail}:   Boolean. Has the evaluation of the gene failed?
#'    }
#'
#' @section Abstract Interface of a Problem Environment for the TSP:
#'
#' A problem environment \code{penv} for the TSP must provide:
#'   \itemize{
#'     \item \code{$name()}: Returns the name of the problem environment.
#'     \item \code{$genelength()}: The number of bits of the binary coded
#'                        real parameter vector. Used in \code{InitGene}.
#'     \item \code{$dist()}: The distance matrix of the TSP.
#'     \item \code{$cities()}: A list of city names or \code{1:numberOfCities}.
#'     \item \code{$f(permutation, gene, lF)}: 
#'           Returns the fitness of the permutation (the length of a tour).
#'     \item \code{$solution()}: The minimal tour length (if known).
#'     \item \code{$path()}: An optimal TSP tour.
#'     \item \code{$show(permutation)}: Prints the tour with the distances
#'           and the cumulative distances between the cities.  
#'     \item TSP Heuristics:
#'     \itemize{
#'     \item \code{$greedy(startposition, k)}: 
#'           Computes a greedy tour of length k.
#'     \item \code{$kBestgreedy(k)}: 
#'           Computes the best greedy tour of length k.
#'     \item \code{$rnd2Opt(permutation, maxTries)}: 
#'           Generate a new permutation by a random 2-change.
#'           \code{maxTries} is the maximal number of trials 
#'           to find a better permutation. 
#'           \code{$rnd2Opt} either returns
#'           a better permutation or, if no better permutation can be found 
#'           in \code{maxTries} attempts, the original permutation.   
#'     \item \code{$LinKernighan(permutation, maxTries)}: 
#'           Returns a permutation generated by a random sequence of 2-changes 
#'           with improving performance. The optimality criterion of the 
#'           k Lin-Kernighan heuristics is replaced by the necessity of 
#'           finding a sequence of random 2-changes with strictly 
#'           increasing performance. 
#'           }    
#'   } 
#'
#' @section Abstract Interface of Mutation Functions:
#'
#' Each mutation function has the following function signature:
#'
#'     \code{newGene<-Mutate(gene, lF)}
#'
#' All local parameters of the mutation function configured are 
#' expected in the local configuration \code{lF}.
#' 
#' @section Local Constants of Mutation Functions:
#'
#' The local constants of a mutation function determine the 
#' the behavior of the function. 
#'
#' \tabular{rcl}{ 
#' \strong{Constant} \tab \strong{Default} \tab \strong{Used in} \cr 
#' \code{lF$BitMutationRate1()} \tab 0.005 \tab xegaPermMutateGeneOrderBased \cr 
#' \code{lF$Lambda()}  \tab 0.05         \tab xegaPermMutateGenekInversion \cr 
#'                     \tab              \tab xegaPermMutateGenekGreedy \cr 
#'                     \tab              \tab xegaPermMutateGeneBestGreedy \cr 
#' \code{lF$max2Opt()} \tab 100          \tab xegaPermMutateGene2Opt \cr
#'                     \tab              \tab xegaPermMutateGenekOptLK \cr
#' }
#'
#' @section Abstract Interface of Crossover Functions:
#'
#' The signatures of the abstract interface to the 2 families 
#' of crossover functions are:
#'
#'     \code{ListOfTwoGenes<-Crossover2(gene1, gene2, lF)} 
#'
#'     \code{newGene<-Crossover(gene1, gene2, lF)}
#'
#' @section The Architecture of the xegaX-Packages:
#' 
#' The xegaX-packages are a family of R-packages which implement 
#' eXtended Evolutionary and Genetic Algorithms (xega).  
#' The architecture has 3 layers, 
#' namely the user interface layer,
#' the population layer, and the gene layer: 
#' 
#' \itemize{
#' \item
#' The user interface layer (package \code{xega}) 
#' provides a function call interface and configuration support
#' for several algorithms: genetic algorithms (sga), 
#' permutation-based genetic algorithms (sgPerm), 
#' derivation free algorithms as e.g. differential evolution (sgde), 
#' grammar-based genetic programming (sgp) and grammatical evolution
#' (sge). 
#'
#' \item
#' The population layer (package \code{xegaPopulation}) contains
#' population related functionality as well as support for 
#' population statistics dependent adaptive mechanisms and parallelization.
#'
#' \item 
#' The gene layer is split in a representation independent and 
#' a representation dependent part:
#' \enumerate{
#' \item 
#'  The representation indendent part (package \code{xegaSelectGene})
#'  is responsible for variants of selection operators, evaluation 
#'  strategies for genes, as well as profiling and timing capabilities.        
#' \item 
#'  The representation dependent part consists of the following packages: 
#' \itemize{
#' \item \code{xegaGaGene} for binary coded genetic algorithms.
#' \item \code{xegaPermGene} for permutation-based genetic algorithms.
#' \item \code{xegaDfGene} for derivation free algorithms as e.g. 
#'                         differential evolution.
#' \item \code{xegaGpGene} for grammar-based genetic algorithms.
#' \item \code{xegaGeGene} for grammatical evolution algorithms.
#' }
#' The packages \code{xegaDerivationTrees} and \code{xegaBNF} support
#' the last two packages:
#' \code{xegaBNF} essentially provides a grammar compiler and 
#' \code{xegaDerivationTrees} an abstract data type for derivation trees.
#' }} 
#'
#' @family Package Description
#'
#' @name xegaPermGene
#' @aliases xegaPermGene
#' @docType package
#' @title Package xegaPermGene.
#' @author Andreas Geyer-Schulz
#' @section Copyright: (c) 2023 Andreas Geyer-Schulz
#' @section License: MIT
#' @section URL: <https://github.com/ageyerschulz/xegaPermGene>
#' @section Installation: From CRAN by \code{install.packages('xegaPermGene')}
NULL

