% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfReplicate.R
\name{xegaDfReplicateGeneDE}
\alias{xegaDfReplicateGeneDE}
\title{Replicates a gene (differential evolution).}
\usage{
xegaDfReplicateGeneDE(pop, fit, lF)
}
\arguments{
\item{pop}{Population of real-coded genes.}

\item{fit}{Fitness vector.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A list of one gene.
}
\description{
\code{xegaDfReplicateGeneDE()} replicates a gene. Replication
             is the reproduction function which uses crossover and
             mutation. The control flow of differential evolution 
             is as follows:
             \itemize{
             \item A target gene is selected from the population.
             \item A mutant gene is generated by differential mutation.
             \item The gene and the mutant gene are crossed to get a 
                   new gene.
             \item The gene is accepted if it is at least as good 
                   as the target gene.
             }
}
\details{
For \code{selection="UniformP"},
         for \code{crossover="UPCrossGene"} and
         for \code{accept="Best"}
         this is 
         the algorithm of Price, Storn and Lampinen (2005), page 41.
}
\examples{
pop10<-lapply(rep(0,10), function(x) xegaDfGene::xegaDfInitGene(lFxegaDfGene))
epop10<-lapply(pop10, lFxegaDfGene$EvalGene, lF=lFxegaDfGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaDfReplicateGeneDE(pop10, fit10, lFxegaDfGene)
}
\references{
Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134.
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\seealso{
Other Replication: 
\code{\link{xegaDfReplicateGeneDEPipeline}()}
}
\concept{Replication}
