% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_eqtlExp}
\alias{xQTLdownload_eqtlExp}
\title{Download normalized expression for gene with a variant-gene pair}
\usage{
xQTLdownload_eqtlExp(
  variantName = "",
  gene = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = ""
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}
}
\value{
A data.table object.
}
\description{
Download normalized expression for gene with a variant-gene pair
}
\examples{
\donttest{
# Download exp with variant-gene pair in different tissues:
xQTLdownload_eqtlExp(variantName="rs1641513",gene="TP53", tissueSiteDetail="Liver")

# Download expression using variant ID and gencode ID.
xQTLdownload_eqtlExp(variantName="chr1_14677_G_A_b38",gene="ENSG00000228463.9",
                     tissueSiteDetail="Stomach")
}
}
