% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replMissingProtNames.R
\name{replMissingProtNames}
\alias{replMissingProtNames}
\title{Complement missing EntryNames in annotation}
\usage{
replMissingProtNames(
  x,
  annCol = c("EntryName", "Accession", "SpecType"),
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(list) output of \code{readMaxQuantFile}, \code{readProtDiscovFile} or \code{readProlineFile}. 
This list must be a matrix and contain $annot with the columns designated in \code{annCol}.}

\item{annCol}{(character) the column-names form \code{x$annot}) which will be used : The first column designs the
column where empty fields are searched and the 2nd and (optional) 3rd will be used to fill the empty spots in the st column}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list as input, but with missing elments of $annot completed (if available in other columns)
}
\description{
This function helps replacing missing EntryNames (in $annot) after reading quantification results. 
To do so the comumn-names of \code{annCol} will be used : 
The content of 2nd element (and optional 3rd element) will be used to replace missing content in column defined by 1st element.
}
\examples{
dat <- list(quant=matrix(sample(11:99,9,replace=TRUE), ncol=3), annot=cbind(EntryName=c(
  "YP010_YEAST","",""),Accession=c("A5Z2X5","P01966","P35900"), SpecType=c("Yeast",NA,NA)))
replMissingProtNames(dat)
}
\seealso{
\code{\link{readMaxQuantFile}}, \code{\link{readProtDiscovFile}}, \code{\link{readProlineFile}}
}
