% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileAsClu.R
\name{profileAsClu}
\alias{profileAsClu}
\title{Plot profile(s) according to CLustering}
\usage{
profileAsClu(
  dat,
  clu,
  meanD = NULL,
  tit = NULL,
  col = NULL,
  pch = NULL,
  xlab = NULL,
  ylab = NULL,
  meCol = "grey",
  meLty = 1,
  meLwd = 1,
  legLoc = "bottomleft",
  silent = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main input with data to plot as points}

\item{clu}{(numeric or character) clustering results; if length=1 and character this term will be understood as colum-name with cluster-numbers from \code{dat}}

\item{meanD}{(numeric) mean/representative of multiple series for display as lines; if length=1 and character this term will be understood as columname with cluster-numbers from \code{dat}}

\item{tit}{(character) optional custom title}

\item{col}{(character) custom colors}

\item{pch}{(integer) custom plotting symbols (see also \code{\link[graphics]{par}})}

\item{xlab}{(character) custom x-axis label}

\item{ylab}{(character) custom y-axis label}

\item{meCol}{(character) color for (dashed) line of mean/representative values}

\item{meLty}{(integer) line-type line of mean/representative values (see also \code{lty} in \code{\link[graphics]{par}})}

\item{meLwd}{(numeric) line-width line of mean/representative values (see also \code{lwd} in \code{\link[graphics]{par}})}

\item{legLoc}{(character) legend location}

\item{silent}{(logical) suppress (less important) messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
plot only
}
\description{
This function was made for visualuzing the result of clustering of a numeric vector or clustering along multiple columns of a matrix.
The data will be plotted like a reglar scatter-plot, but some extra space is added to separate clusters and dashed lines highlight cluster-borders.
If no mean/representative value is spacified, a geometric mean will be calculated along all columns of  \code{dat}.
In case \code{dat} has multiple columns, a legend and a representative (default geometric mean) dashed grey line will be displayed.
}
\examples{
set.seed(2020); dat1 <- runif(12)/2 + rep(6:8, each=4)
dat1Cl <- stats::kmeans(dat1, 3)$cluster
dat1Cl <- 5- dat1Cl              # bring cluster-numbers in ascending form
dat1Cl[which(dat1Cl >3)] <- 1    # bring cluster-numbers in ascending form
profileAsClu(dat1, clu=dat1Cl)

}
