\name{mts2ts}
\alias{mts2ts}
\title{
Converts matrix to vector time series for various analyses
}
\description{
First aggregates multivariate matrix time series by year. Then converts to a vector time series in which \dQuote{seasons} correspond to these annnualized values for the original variables.
}
\usage{
mts2ts(x, seas = 1:frequency(x), na.rm = FALSE)
}
\arguments{
  \item{x}{
    An object of class "mts"
}
  \item{seas}{
    Numeric vector of seasons to aggregate in original time series.
}
  \item{na.rm}{
    Should missing data be ignored when aggregating?
}
}
\details{
The \code{seas} parameter enables focusing the subsequent analysis on seasons of special interest, or to ignore seasons where there are too many missing data. The function can be used in conjunction with \code{seaKen} to conduct a Regional Kendall trend analysis. Sometimes just plotting the resulting function can be useful for exploring a spatial transect over time.}
\value{
A vector time series
}
\seealso{
\code{\link{seaKen}}
}
\examples{
## Quick plot a spatial transect of chlorophyll a during the 
## spring bloom period (Feb-Apr) for each year.
y <- mts2ts(sfbayChla, seas = 2:4)
plot(y, type = 'n')
abline(v = 1978:2010, col = 'lightgrey')
lines(y, type = 'h')
}
\keyword{ts}
\keyword{manip}
