% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_view.R
\name{wflow_view}
\alias{wflow_view}
\title{View research website locally}
\usage{
wflow_view(files = NULL, recent = FALSE, dry_run = FALSE, project = ".")
}
\arguments{
\item{files}{character (default: NULL). Name(s) of the specific file(s) to
view. These can be either the name(s) of the R Markdown file(s) in the
analysis directory or the HTML file(s) in the docs directory. Also, the
full path(s) to the file(s) can be input or just the basename(s) of the
file(s). Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.}

\item{recent}{logical (default: FALSE). If \code{files = NULL}, display the
HTML file with the most recent modification time. If \code{files = NULL}
and \code{recent = FALSE}, then \code{index.html} is viewed.}

\item{dry_run}{logical (default: FALSE). Do not actually view file(s). Mainly
useful for testing.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns a character vector of the relative paths to the
  HTML files to be viewed.
}
\description{
\code{wflow_view} displays the website locally in your browser or the RStudio
Viewer pane.
}
\details{
\code{wflow_view} by default displays the file \code{index.html}. To view the
most recently modified HTML file, set \code{recent = TRUE}. To specify which
file(s) to view, specify either the name(s) of the R Markdown or HTML
file(s). The path(s) to the file(s) will be discarded, thus only HTML files
in docs directory can be viewed with this function.

\code{wflow_view} uses \code{\link{browseURL}} to view the HTML files in the
browser. If you wish to do something non-traditional like view an HTML file
that is not in the docs directory or not part of a workflowr project, you can
use that function directly.

If \code{wflow_view} is run in the RStudio IDE and only one file has been
requested to be viewed, the file is displayed in the
\href{https://rstudio.github.io/rstudio-extensions/rstudio_viewer.html}{RStudio
Viewer}.
}
\examples{
\dontrun{

# View index.html
wflow_view()

# View the most recently modified HTML file
wflow_view(recent = TRUE)

# View a file by specifying the R Markdown file
# (the following two are equivalent)
wflow_view("fname.Rmd")
wflow_view("analysis/fname.Rmd")

# View a file by specifying the HTML file
# (the following two are equivalent)
wflow_view("fname.html")
wflow_view("docs/fname.html")

# View multiple files
wflow_view(c("fname1.Rmd", "fname2.Rmd"))
}
}
\seealso{
\code{\link{browseURL}}
}
