% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{has_git_user}
\alias{has_git_user}
\title{Check whether global 'Git' credentials exist}
\usage{
has_git_user(repo = ".")
}
\arguments{
\item{repo}{The path to the git repository.}
}
\value{
Logical, indicating whether 'Git' global configuration settings could
be retrieved, and contained the values
\code{user.name} and \code{user.email}.
}
\description{
Check whether the values \code{user.name} and \code{user.email}
exist exist for the current repository.
Uses \code{\link[gert:git_signature]{git_signature_default}}.
}
\examples{
testdir <- file.path(tempdir(), "test_git_user")
dir.create(testdir)
gert::git_init(testdir)
has_git_user(testdir)
unlink(testdir, recursive = TRUE)
}
