% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url-packages.R
\name{wood_url_packages}
\alias{wood_url_packages}
\title{List available packages in any repository}
\usage{
wood_url_packages(repository)
}
\arguments{
\item{repository}{\code{character(1)}\cr
URL to repository, e.g. \code{"http://www.omegahat.net/R"}.}
}
\value{
A character vector of available packages.
}
\description{
This function queries any online repository for a list of
available packages. They are returned as a vector of strings, each element
being a package name. The data is retrieved from \verb{/src/contrib/PACKAGES}
or \verb{/src/contrib/PACKAGES.gz} file.
}
\examples{
\donttest{
wood_url_packages("http://www.omegahat.net/R")
# Trailing slashes are removed
wood_url_packages("http://www.omegahat.net/R/")
}

}
\seealso{
Functions for any URL:
\code{\link{wood_url_dependencies}()},
\code{\link{wood_url_version}()}

Functions that query available packages:
\code{\link{wood_bioc_packages}()},
\code{\link{wood_core_packages}()},
\code{\link{wood_cran_packages}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_local_packages}()},
\code{\link{wood_packages}()},
\code{\link{wood_runiverse_packages}()}
}
\concept{packages}
\concept{url}
