% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{density}
\alias{density}
\title{Create a Density Plot}
\usage{
density(x, ...)
}
\arguments{
\item{x}{an object of class weightfunct}

\item{...}{other arguments}
}
\description{
This function allows you to create a plot displaying the unadjusted and adjusted densities of the specified model. Note that you must first specify a model using \code{weightfunct}.
}
\details{
This function produces an approximate graphical illustration of the estimated unweighted and weighted densities. The unweighted density is represented by a dashed line and the weighted density by a solid line. For the unweighted density, the effect sizes are assumed to be normally distributed, with a mean equal to their unadjusted mean and a variance equal to their unadjusted variance component plus their individual sampling variances. This plot is an approximation because it is necessary to use a fixed sampling variance; here, we fix the sampling variance to the median of the distribution of sampling variances.

For the adjusted density, the expected density for effect sizes within each specified p-value interval is multiplied by the estimated weight for the corresponding interval. Greater density in an interval then represents a greater likelihood of effect-size survival. (Remember, of course, that the weight for the first interval is fixed to one, and other intervals should be interpreted relative to it.) Each discontinuity in the solid line, therefore, represents a p-value cutpoint.

Users may wonder why the adjusted density, or the solid line, sometimes falls outside of the unadjusted density, or the dashed line. In answer, recall that the mean and variance of the adjusted density also differ. Based on the severity of this difference, the adjusted density may fall outside of its unadjusted counterpart.
}
\examples{
\dontrun{
test <- weightfunct(effect, v, steps)
density(test)
}
}
\keyword{weightr}
