% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_opts.R
\name{wm_opts_defaults}
\alias{wm_opts_defaults}
\title{WebmorphR default options}
\usage{
wm_opts_defaults()
}
\value{
a list of default options
}
\description{
Options set on load (unless they were already set by .Renviron)
\itemize{
\item overwrite ("ask"): Whether to overwrite images saved with \code{\link[=write_stim]{write_stim()}} when in interactive mode; possible values are "ask" (ask if filenames exist), TRUE (always overwrite), and FALSE (never overwrite)
\item fill ("white"): the colour to use to fill image backgrounds
\item pt.color ("green") : the colour to use for points in \code{\link[=draw_tem]{draw_tem()}}
\item line.color ("blue"): the colour to use for lines in \code{\link[=draw_tem]{draw_tem()}}
\item plot ("inline"): whether to plot images inline in R markdown documents (set to any other value to just view them in the viewer)
\item plot.maxwidth (2400): The maximum width of images created by \code{\link[=plot]{plot()}}
\item plot.maxheight (2400): The maximum height of images created by \code{\link[=plot]{plot()}}
\item verbose (TRUE): Whether to produce verbose output and progress bars for long functions like \code{\link[=auto_delin]{auto_delin()}}, \code{\link[=avg]{avg()}} or \code{\link[=trans]{trans()}}
\item server ("https://webmorph.org"): The server to use for webmorph functions like \code{\link[=avg]{avg()}} and \code{\link[=trans]{trans()}}; do not change unless you've set up a local server
\item connection (stdin()): use internally for testing interactive functions; do not change
}
}
\examples{
wm_opts_defaults() |> str() # view defaults

\dontrun{
# reset all options to default
wm_opts_defaults() |> wm_opts()
}
}
\seealso{
\code{\link[=wm_opts]{wm_opts()}}
}
