% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_size.R
\name{to_size}
\alias{to_size}
\title{Resize and crop/pad images to a specified size}
\usage{
to_size(
  stimuli,
  width = NULL,
  height = NULL,
  fill = wm_opts("fill"),
  crop = FALSE,
  keep_rels = FALSE
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{width}{the target width (if null, the maximum stimulus width is used)}

\item{height}{the target height (if null, the maximum stimulus height is used)}

\item{fill}{background color if cropping goes outside the original image, see \code{\link[=color_conv]{color_conv()}}}

\item{crop}{whether to crop or pad images to make them the specified size}

\item{keep_rels}{whether to keep the size relationships between images in the set, or make all the maximum size}
}
\value{
list of stimuli with cropped tems and/or images
}
\description{
Resize and crop/pad images to a specified size
}
\examples{

# images with different aspect ratios and sizes
stimuli <- demo_unstandard(c(1:4, 6:9))

to_size(stimuli, 200, 200, fill = "dodgerblue")

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()}
}
\concept{manipulators}
