% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_fullscreen_button.R
\name{add_fullscreen_button}
\alias{add_fullscreen_button}
\title{Add full-screen button to a web map}
\usage{
add_fullscreen_button(map, pseudo_fullscreen = FALSE, position = "topleft")
}
\arguments{
\item{map}{'\link{leaflet}'.
Map widget object}

\item{pseudo_fullscreen}{'logical' flag.
Whether to fullscreen to page width and height.}

\item{position}{'character' string.
Position of the button on the web map.
Possible values are "topleft", "topright", "bottomleft", and "bottomright".}
}
\value{
A new HTML web \code{map} with added element, an object of class 'leaflet'.
}
\description{
Add a button to a \href{https://leafletjs.com/}{Leaflet} map that toggles full screen on and off.
Functionality provided by the \href{https://github.com/Leaflet/Leaflet.fullscreen}{leaflet-fullscreen}
plugin for Leaflet.
}
\examples{
make_map(maps = "Topo") |>
  add_fullscreen_button()
}
\seealso{
\code{\link{make_map}} function for creating a map widget.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
