% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{glossary}
\alias{glossary}
\title{webfakes glossary}
\description{
webfakes glossary
}
\section{Webfakes glossary}{


The webfakes package uses vocabulary that is standard for web apps, especially those developed with Express.js, but not necessarily well known to all R package developers.
\subsection{app}{

(Also: fake web app, webfakes app.) A web application that can be served by webfakes's web server, typically in another process, an \emph{app process}.
Sometimes we call it a \emph{fake} web app, to emphasize that we use it for testing real web apps and APIs.

You can create a webfakes app with the \code{new_app()} function.
A webfakes app is an R object that you can save to disk with \code{saveRDS()} , and you can also include it in your package.

You can start an with its \verb{$listen()} method.
Since the main R process runs that test suite code, you usually run them in a subprocess, see \code{new_app_process()} or \code{local_app_process()}.
}

\subsection{app process}{

(Also: web server process, webfakes subprocess.) An app process is an R subprocess, started from the main R process, to serve a webfakes \emph{app}.

You can create an app process object with \code{new_app_process()} or \code{local_app_process()}.
By default the actual process does not start yet, when you create it.
You can start it explicitly with the \verb{$start} method of the app process object, or by querying its URL with \verb{$url()} or its port with \verb{$get_port()}.

For test cases, you typically start app processes at these places:
\itemize{
\item In a \code{setup*.R} file, to start an app that the whole test suite can use.
\item Alternatively, in a \code{helper*.R} file, to start an app that the whole test suite can use, and it works better for interactive development.
\item At the beginning of a test file, to create an app for a single test file.
\item Inside \code{test_that()}, to create an app for a single test block.
}

See the How-to for details about each.
}

\subsection{handler}{

(Or handler function.) A handler is a \emph{route} or a \emph{middleware}.
}

\subsection{handler stack}{

This is a stack of handler functions, which are called by the app one after the other, passing the request and response objects to them.
Handlers typically manipulate the request and/or response objects.
A terminal handler instructs the app to return the response to the HTTP client.
A non-terminal handler tells the app to keep calling handlers, by returning the string \code{"next"}.
}

\subsection{httpbin app}{

This is an example app, which implements the excellent \url{https://httpbin.org/} web service.
You can use it to simulate certain HTTP responses.
It is most handy for HTTP clients, but potentially useful for other tools as well.

Use \code{httpbin_app()} to create an instance of this app.
}

\subsection{middleware}{

A middleware is a handler function that is not bound to a path.
It is called by the router, like other handler functions.
It may manipulate the request or the response, or can have a side effect.
Some example built-in middleware functions in webfakes:
\itemize{
\item \code{mw_json()} parses a request's JSON body into an R object.
\item \code{mw_log()} logs requests and responses to the screen or to a file.
\item \code{mw_static()} serves static files from the directory.
}

You can also write your own middleware functions.
}

\subsection{path matching}{

The router performs path matching when it goes over the handler stack.
If the HTTP method and path of a \emph{route} match the HTTP method and URL of the request, then the handler is called, otherwise it is not.
Paths can have parameters and be regular expressions.
See \code{?new_regexp()} for regular expressions and "Path parameters" in \code{?new_app()} for parameters.
}

\subsection{route}{

A route is a handler function that is bound to certain paths of you web app.
If the request URL matches the path of the route, then the handler function is called, to give it a chance to send the appropriate response.
Route paths may have parameters or they can be regular expressions in webfakes.
}

\subsection{routing}{

Routing is the process of going over the handlers stack, and calling handler functions, one after the other, until one handles the request.
If a handler function is a \emph{route}, then the router only calls it if its path matches the request URL.
}
}

