% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flavornet.R
\name{fn_percept}
\alias{fn_percept}
\title{Retrieve flavor percepts from www.flavornet.org}
\usage{
fn_percept(query, from = "cas", verbose = getOption("verbose"), CAS, ...)
}
\arguments{
\item{query}{character; CAS number to search by. See \code{\link{is.cas}} for correct formatting}

\item{from}{character; currently only CAS numbers are accepted.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{CAS}{deprecated}

\item{...}{currently unused}
}
\value{
A named character vector containing flavor percepts or NA's in the case of CAS numbers that are not found
}
\description{
Retrieve flavor percepts from \url{http://www.flavornet.org}.  Flavornet is a database of 738 compounds with odors
perceptible to humans detected using gas chromatography olfactometry (GCO).
}
\examples{
\dontrun{
# might fail if website is not available
fn_percept("123-32-0")

CASs <- c("75-07-0",  "64-17-5",  "109-66-0", "78-94-4",  "78-93-3")
fn_percept(CASs)
}
}
