# `ww_area_of_applicability` is not defined for vectors

    `x` isn't a supported object type.
    i `ww_area_of_applicability()` can only handle data.frames, matrices, formulas, and recipes.
    x `x` is a numeric

# NAs are handled

    Missing values in the training set data (either `x` or `data`).
    i Either process your data to fix the NA values or set `na_action`.

---

    Code
      ww_area_of_applicability(y ~ ., train, test, importance, na_action = na.omit)
    Output
      # Predictors:
         10
      Area-of-applicability threshold:
         0.3083

---

    Missing values in the training set data (either `x` or `data`).
    i Either process your data to fix the NA values or set `na_action`.

---

    Code
      ww_area_of_applicability(train[2:11], test[2:11], importance, na_action = na.omit)
    Output
      # Predictors:
         10
      Area-of-applicability threshold:
         0.3083

---

    Missing values in the training set data (either `x` or `data`).
    i Either process your data to fix the NA values or set `na_action`.

---

    Code
      ww_area_of_applicability(as.matrix(train[2:11]), as.matrix(test[2:11]),
      importance, na_action = na.omit)
    Output
      # Predictors:
         10
      Area-of-applicability threshold:
         0.3083

---

    Missing values in the training set data (either `x` or `data`).
    i Either process your data to fix the NA values or set `na_action`.

---

    Code
      ww_area_of_applicability(comb_rset_no_y, importance = importance, na_action = na.omit)
    Output
      # Predictors:
         10
      Area-of-applicability threshold:
         0.3083

---

    Missing values in the training set data (either `x` or `data`).
    i Either process your data to fix the NA values or set `na_action`.

---

    Code
      ww_area_of_applicability(comb_rset, recipes::recipe(y ~ ., train), importance = importance,
      na_action = na.omit)
    Output
      # Predictors:
         10
      Area-of-applicability threshold:
         0.3083

---

    Code
      predict(ww_area_of_applicability(y ~ ., train, test, importance, na_action = na.omit),
      test)
    Output
      # A tibble: 300 x 2
              di aoa  
           <dbl> <lgl>
       1 NA      NA   
       2  0.191  TRUE 
       3  0.190  TRUE 
       4  0.0802 TRUE 
       5  0.141  TRUE 
       6  0.288  TRUE 
       7  0.178  TRUE 
       8  0.205  TRUE 
       9  0.134  TRUE 
      10  0.177  TRUE 
      # ... with 290 more rows

# normal use

    Code
      predict(aoa, test)
    Output
      # A tibble: 300 x 2
             di aoa  
          <dbl> <lgl>
       1 0.175  TRUE 
       2 0.191  TRUE 
       3 0.190  TRUE 
       4 0.0802 TRUE 
       5 0.141  TRUE 
       6 0.287  TRUE 
       7 0.178  TRUE 
       8 0.205  TRUE 
       9 0.134  TRUE 
      10 0.177  TRUE 
      # ... with 290 more rows

---

    Code
      predict(aoa, train)
    Output
      # A tibble: 700 x 2
            di aoa  
         <dbl> <lgl>
       1     0 TRUE 
       2     0 TRUE 
       3     0 TRUE 
       4     0 TRUE 
       5     0 TRUE 
       6     0 TRUE 
       7     0 TRUE 
       8     0 TRUE 
       9     0 TRUE 
      10     0 TRUE 
      # ... with 690 more rows

# `new_ww_area_of_applicability` arguments are assigned correctly

    Code
      x$transformed_training
    Output
                    x1           x2           x3           x4            x5
      1   -0.202710888 -0.582868552  0.123208250  0.069979924  0.2010312494
      2   -0.718833876  0.138799130  0.174754226  0.053792584 -0.2098647689
      3    0.327734064 -0.363729121 -0.291514859  0.453419809 -0.0927503671
      4    0.246012797  0.051926222 -0.161380475 -0.592965581 -0.0170295803
      5   -0.395003640 -0.176669473 -0.018324413 -0.412624237 -0.0093549223
      6   -0.316102907  0.700581571  0.107007341  0.858539372  0.1241498698
      7    0.131551627 -0.321416246  0.216806130  0.452911354  0.2157458964
      8   -0.263586921  0.507667853  0.125811477 -0.431945890  0.0061180805
      9    0.189935020 -0.023649558 -0.014638972  0.174732614  0.0953001525
      10   0.070193319 -0.042862434  0.206998273 -0.563892476 -0.0269403906
      11   0.595108102  0.139103638 -0.057085198 -0.935507841  0.1254705003
      12   0.323318566 -0.422519505  0.222733465 -0.138044841  0.0374764644
      13   0.362766259  0.284214259  0.178535045 -0.918324608  0.2610572572
      14   0.676585866 -0.294557946 -0.025400664  0.960174016  0.1422063810
      15  -0.072377426 -0.305717535  0.242334233 -0.892598422 -0.1690190557
      16   0.140122572  0.162649913  0.007195259 -0.209064449  0.1184729575
      17   0.501809262  0.181960920 -0.190693090  0.686788738 -0.1097568978
      18  -0.435456296 -0.003146630  0.029894159  0.484504716 -0.2676126072
      19  -0.140676126 -0.144139095 -0.253214463  0.214411974 -0.0369703351
      20  -0.727029410  0.132096129  0.219130866 -0.367873196  0.2236732272
      21   0.313631529  0.524552915 -0.012677860  0.792548770  0.0160756277
      22   0.716198876  0.572569208  0.151126967  0.060126633  0.2219986753
      23  -0.452378569  0.108297007  0.221541385 -0.494658307 -0.0489135024
      24   0.251311348  0.142173120 -0.217762987 -0.784595299  0.1680383421
      25   0.663515860 -0.017724982 -0.059844108  0.597406793 -0.2294910593
      26   0.462961226  0.626131416  0.131149675  0.976775797  0.0056904849
      27  -0.675787043  0.097298697  0.208272367  0.897100289 -0.0340004987
      28  -0.175661931 -0.115659654 -0.226868793 -0.459944481 -0.2436348960
      29  -0.148873795  0.053521761 -0.202451335 -0.777403951  0.1400635983
      30   0.248629270  0.413711411 -0.104333507 -0.809262106  0.1594766140
      31  -0.122317521  0.351553983 -0.174194021 -0.689041538 -0.0767981915
      32  -0.283206670  0.159241302 -0.254413387  0.183262406  0.0948612469
      33  -0.476931385 -0.483498789 -0.295646880 -0.822167760 -0.1216605442
      34  -0.531252264 -0.479695575 -0.290736074  0.525906205  0.2395633166
      35   0.034801344 -0.283821346  0.277073681 -0.684293274  0.0553319791
      36   0.648049423 -0.581206673  0.294127310 -0.424205953  0.2668625110
      37  -0.462719594 -0.359305655 -0.200832868  0.916873867  0.0637538225
      38   0.492138126  0.246921111 -0.003951057  0.562435483 -0.2212430383
      39  -0.756017868 -0.080913445 -0.209278644 -0.892763117  0.2195465602
      40   0.665850752 -0.280653297  0.049100356 -0.857284366 -0.1616098428
      41  -0.104062210 -0.351998086 -0.134868844  0.311875424 -0.1620453006
      42  -0.092913843  0.427825459 -0.082915382  0.726825569 -0.2492840921
      43   0.407902146  0.181906033  0.168910890 -0.899676385 -0.2620476795
      44  -0.264381983  0.170064721 -0.268479254  0.657772937  0.1302991096
      45  -0.167882708 -0.025463227 -0.102075672  0.330423959 -0.1263183430
      46  -0.421034177  0.311479037  0.297859367 -0.788340559 -0.2714345263
      47  -0.675166037  0.554190425 -0.060464797 -0.701121604 -0.1865402684
      48   0.647899845  0.100520130  0.051295325  0.313420252  0.1699847175
      49   0.425197930  0.630786593  0.158333960  0.027876769 -0.0530068036
      50  -0.618694458  0.706658970  0.222120554  0.258467244 -0.1452144299
      51  -0.663213476 -0.186455528 -0.137356092  0.147721396  0.0871865189
      52  -0.105747601  0.700584019  0.291267133 -0.579049441  0.0280525875
      53   0.280723213  0.474897095  0.165975126  0.782199623  0.0283498501
      54   0.366512768 -0.658214518  0.263457226  0.205228600 -0.1902260017
      55  -0.076479269  0.382029920 -0.063431474 -0.646716398 -0.2681587759
      56   0.444203823 -0.002328285 -0.283232440 -0.787085442 -0.2516250436
      57   0.280819546  0.693386190  0.185865465 -0.027240297  0.2247770473
      58   0.027559600 -0.178846047 -0.299268350  0.975305460  0.1731570107
      59   0.298062046 -0.632558560 -0.223186969 -0.396031723  0.1851626106
      60   0.136909780 -0.410580423  0.192749151  0.384187643 -0.0400762999
      61   0.492620108  0.518497517 -0.159523998 -0.130852870 -0.2135679990
      62   0.485476915 -0.037774936 -0.216865873  0.202669397  0.0285133073
      63   0.170954403 -0.298859270  0.228222003  0.100124586  0.0408014797
      64   0.773681408  0.178579562  0.094821560 -0.638996726  0.0481419719
      65   0.537652281  0.590484212  0.294021387 -0.923832736 -0.2024301276
      66   0.336880714 -0.203919400  0.265332867  0.796932369 -0.2398197690
      67  -0.757724810 -0.464960073 -0.185140625  0.109131820  0.2025212791
      68  -0.308204178 -0.419702544 -0.036955635 -0.663574581 -0.1255867682
      69   0.600062675 -0.115956689  0.267702640  0.903316197 -0.0281479067
      70   0.691851367  0.072073082  0.202536662  0.885852132 -0.0729410103
      71  -0.419267953 -0.452508062  0.304865417  0.218905120 -0.0619244976
      72   0.684493998  0.658785366  0.112260718  0.863209395 -0.0974388011
      73   0.103001238  0.129541395 -0.261119415  0.617438299 -0.1387862191
      74   0.536944771  0.036942212 -0.152151282 -0.096787277 -0.0869953304
      75   0.503168964  0.551361588 -0.183093518 -0.666263509  0.2512513796
      76  -0.347666870  0.396465431 -0.264950997 -0.517846177  0.1918836332
      77  -0.713369947 -0.493691431 -0.054410530 -0.694475347 -0.2595170353
      78  -0.434164081 -0.404106892 -0.013933538 -0.450053993 -0.1523007939
      79   0.270221371  0.297178450  0.266558223 -0.896951066  0.2669303652
      80   0.719489184  0.358385133 -0.072874616 -0.849159429  0.1684320517
      81   0.289345431  0.372484437  0.006811835 -0.899083323  0.0357946828
      82   0.431656921 -0.474502444 -0.115650178 -0.584443841 -0.2213088644
      83   0.431712725 -0.674850720 -0.107037968  0.522741966  0.0677022521
      84   0.756997467 -0.387353555  0.223421916  0.031010520 -0.0162337516
      85  -0.771701715  0.119182141  0.226211816 -0.757515071  0.1922780261
      86   0.709516383  0.198837894  0.182805436 -0.526712775  0.2480111692
      87  -0.280139521 -0.546075986 -0.247114111  0.375760927 -0.0431095100
      88  -0.114995972  0.468385795  0.109820090 -0.154568556  0.1099790751
      89  -0.576319846  0.590682853 -0.007772394  0.527775169  0.1086701292
      90  -0.758908147 -0.625303390 -0.086557623  0.978644438 -0.2262358642
      91   0.244141003  0.658063358  0.081454988 -0.701722889 -0.0108831604
      92   0.650021480 -0.275000949  0.039452735  0.077112258 -0.1814782771
      93   0.336560782  0.158102328  0.256608189 -0.536539923  0.1987889971
      94  -0.500160811  0.141259453 -0.143855096  0.817462410 -0.2029718573
      95  -0.410387279 -0.475998005 -0.017179678 -0.736381236 -0.0233458185
      96   0.526977761 -0.524571150 -0.166929483  0.406269102 -0.0409316960
      97  -0.181217005  0.333743282 -0.076066717 -0.650705325  0.2245915776
      98  -0.422166593 -0.420183708  0.290830917 -0.692391816  0.1172582460
      99  -0.679389372 -0.438710765 -0.002072271  0.259166259  0.1176854682
      100 -0.689914023  0.690195006 -0.120782211 -0.203955159 -0.0976155907
      101 -0.591215872 -0.507526439  0.128764713 -0.002226083 -0.1764095940
      102 -0.751051917 -0.463679612 -0.278303333  0.933591397  0.0141381518
      103 -0.171805615  0.083857525  0.244312888  0.899253280  0.1070482343
      104  0.563363097  0.294336886  0.123218803 -0.843633038  0.1149393632
      105  0.341330543  0.331253458  0.173951363  0.542460631  0.0614262795
      106 -0.254269736 -0.504323959  0.168493453  0.956364567 -0.0135284215
      107 -0.660055541 -0.025561549 -0.105422319  0.840450071  0.1302138680
      108 -0.729192515  0.620312227  0.105937954  0.897948751 -0.2071490235
      109  0.427390866 -0.001520052 -0.278792397 -0.427278249 -0.0354524965
      110  0.776310350  0.439671877  0.209450004  0.591806343 -0.1315453173
      111 -0.557317729 -0.173915122  0.011017853  0.552847776  0.0305674832
      112 -0.725089384 -0.222339941 -0.260149210 -0.073872911 -0.1266532818
      113  0.101391632  0.648670083  0.058954827 -0.479317567 -0.0816769876
      114  0.608924058  0.325009856 -0.092294452  0.424603816 -0.0855080509
      115  0.580845883 -0.626972292 -0.254611336 -0.725124212  0.0434658400
      116  0.755354406 -0.703710688 -0.032497973  0.970601862 -0.2718051319
      117  0.595031348  0.125230533 -0.054696946  0.322005030 -0.1897119478
      118  0.014511017  0.667808758  0.022701612  0.676921248  0.1790561269
      119 -0.262159448 -0.289192151 -0.105902749 -0.807352035  0.1915171482
      120  0.176297447 -0.517574108  0.096382425 -0.564612046  0.2288528019
      121 -0.162930008 -0.704620369  0.235722517 -0.286706620  0.0713029170
      122 -0.567771984 -0.556084674 -0.021137917 -0.325461919  0.1868866409
      123 -0.663394942  0.299312081  0.137245543  0.499725650 -0.1994542153
      124  0.077097999  0.384066920 -0.069846141 -0.815883121 -0.0059973889
      125 -0.378045222  0.659107619  0.184278234 -0.159626457  0.2599032071
      126  0.484667312 -0.044033236  0.058810406 -0.118868269  0.1688102381
      127  0.068529018  0.021980118  0.266336767  0.437847878  0.1697077317
      128 -0.041928329 -0.711075535 -0.085659006 -0.027186936  0.1367149423
      129  0.255471034  0.451752057  0.214981290 -0.827717156  0.1638039664
      130 -0.642837227  0.498267086  0.184339770 -0.852327861  0.1763828109
      131  0.234807008 -0.092553921 -0.288185630  0.731725172 -0.0641771887
      132 -0.208556703 -0.153751778 -0.263445828 -0.867957051  0.2604687151
      133 -0.401394124 -0.109406207  0.092050016  0.590173031  0.1230654948
      134 -0.318383716 -0.189705850  0.059912562 -0.726128558  0.1360574757
      135  0.091185930 -0.519489109 -0.155085396 -0.020513955  0.0350258709
      136 -0.032714196 -0.353563716 -0.213080796  0.283424419 -0.1457693106
      137 -0.037966649  0.556968086  0.083619082 -0.678988545 -0.1646770037
      138  0.682716018  0.475108572  0.283740540 -0.256120632  0.0690867736
      139 -0.048711456  0.525201754  0.291531905 -0.096126644  0.2253850269
      140  0.278243602  0.702217519  0.260020326 -0.249593063  0.0844949287
      141  0.681035154 -0.374010280 -0.122758130 -0.080301763  0.0877577109
      142 -0.357055600  0.348415931 -0.186495285  0.297593083  0.0615297103
      143  0.701329494  0.654918810  0.052446274 -0.229424699 -0.2346575495
      144 -0.295281500 -0.579892662  0.297097978 -0.648597559  0.2056780363
      145  0.588477707  0.153615411  0.168205182 -0.831058150  0.2408484909
      146 -0.524666935  0.210861591  0.040886514 -0.902006450 -0.0836022329
      147 -0.050449717 -0.063859049  0.060964773  0.734759521  0.1362252772
      148  0.237429979 -0.551145221 -0.028783423 -0.375296455  0.2459588498
      149 -0.733551957  0.285519095 -0.086538864  0.396192889  0.0400462246
      150 -0.103291154  0.679403792  0.071952963 -0.231718236  0.2444260975
      151 -0.552322804 -0.384974214  0.065081505  0.440193820 -0.1908224679
      152 -0.066427939 -0.314979670 -0.055324916  0.694289684 -0.1291244667
      153  0.184983376  0.148353881 -0.150962100 -0.654968829  0.1642474995
      154  0.715343648  0.142466716  0.245592913 -0.478584525  0.1597009918
      155 -0.629543403  0.165512951 -0.215878819  0.343236588  0.2448800204
      156 -0.429802838 -0.459555200  0.029592324 -0.366885075 -0.2379107433
      157  0.084630221 -0.434813582 -0.246767077 -0.175330531 -0.0588865738
      158  0.424154395 -0.363153103 -0.238555398  0.856937833 -0.0756679113
      159 -0.033793202  0.239291030  0.202313197 -0.309993616  0.0629180517
      160  0.597059558 -0.659184214  0.297533100 -0.312748728  0.0235083427
      161  0.733740009 -0.309408942  0.031896739  0.028630601 -0.2314032396
      162  0.297578395 -0.386759713  0.048467538 -0.717802641  0.0399522713
      163  0.574778024 -0.621948484 -0.148509938 -0.859748968  0.2503747424
      164  0.092913087  0.210908474 -0.182127441  0.489019887 -0.0892991046
      165 -0.309046821 -0.136790199  0.058006167 -0.699147003 -0.0358235741
      166  0.782920045 -0.359568853 -0.173156309  0.400408507 -0.1480515754
      167 -0.326780140  0.162220149  0.035515790  0.666383534  0.0365410038
      168  0.632163247  0.253153714  0.075721686  0.767528685 -0.0497739447
      169 -0.721841837  0.091274908  0.280486267 -0.493496067  0.1291976504
      170  0.153020499  0.641514438 -0.274076426  0.666136669 -0.1416386002
      171  0.282791563 -0.325733926  0.142747218 -0.038962048 -0.2249424456
      172  0.757382478  0.439658696 -0.274047373 -0.542716467 -0.0452713209
      173  0.001539955 -0.139153284  0.306606603  0.149542257 -0.0236529029
      174  0.379848838  0.025570735 -0.129668027  0.754242732 -0.0530302640
      175  0.644433621  0.481843376  0.138311388  0.493085327 -0.1391269672
      176  0.765776277  0.380776503 -0.106839525 -0.154158079  0.0311499193
      177  0.415458146  0.364513019  0.284078715 -0.536301589 -0.0718520445
      178  0.501952522  0.302402918 -0.054357438 -0.678015862  0.0855758351
      179  0.689317297 -0.523931347 -0.097565774  0.158999889 -0.0831725936
      180  0.267917703 -0.651396783 -0.140239083  0.992413564  0.0718629958
      181  0.638640366 -0.074943526 -0.238097247 -0.255768890 -0.0300235227
      182  0.410418006 -0.340131265 -0.288683923  0.599356861  0.1295797144
      183 -0.023319334  0.359947241 -0.276777713  0.831716826 -0.0486987267
      184 -0.394448869  0.397502352 -0.017757169 -0.397745213 -0.2237070576
      185 -0.223385225 -0.661223470  0.264500930 -0.227808856 -0.0465308365
      186 -0.774208728 -0.178115863 -0.096820264  0.603408596 -0.1828786131
      187 -0.417234781  0.083162748  0.286145124  0.053064930  0.0083930869
      188 -0.620740737 -0.254123710  0.081810669 -0.058091780 -0.0709868381
      189  0.172680303 -0.413289787  0.061485177 -0.857810529 -0.1572985471
      190 -0.465982112 -0.025241679 -0.235198239  0.912960551 -0.0597664124
      191 -0.450400638  0.057693408 -0.158950225  0.117305518 -0.0400078861
      192 -0.761794783 -0.446894764 -0.139565923 -0.050811492  0.0703834358
      193 -0.271874439 -0.513985967  0.100873305 -0.863463950  0.1568341751
      194 -0.363977887  0.349852860 -0.191929584 -0.430491250 -0.1292385514
      195  0.648668307  0.092981745  0.140705962  0.838626078  0.2620666779
      196 -0.130923421  0.473193384 -0.035158544  0.832092245  0.0325722951
      197  0.297684660  0.646396120 -0.122384760  0.722695855  0.1855308620
      198  0.626884539  0.095895916 -0.300230216 -0.782796969  0.0518423949
      199 -0.461248100  0.540218039 -0.217945683  0.765931271 -0.1276815592
      200 -0.063084319  0.316847727  0.175051399 -0.364185173  0.2299662940
      201  0.164258371 -0.226957334 -0.163916959 -0.584803848 -0.0566503720
      202  0.096549851  0.523998284  0.036608854 -0.596570304 -0.0488891062
      203 -0.352566499 -0.525075759  0.137413898 -0.681246085 -0.0194504969
      204 -0.432275138  0.478620316  0.010848828  0.058268829 -0.1057673733
      205  0.758196365 -0.230170175 -0.170397495  0.929142374  0.2021903146
      206 -0.633075216 -0.283303387 -0.219094859  0.566183354 -0.2264482926
      207  0.594724541 -0.442412447 -0.172872805 -0.349217722 -0.2455047199
      208 -0.420774529  0.472969538 -0.266951079 -0.175558359 -0.2071066155
      209  0.426302089 -0.360429680 -0.214245770 -0.917405844  0.0407257982
      210 -0.046068210  0.026936547 -0.080777418  0.338168165 -0.1803006181
      211 -0.145106245 -0.720584083 -0.141488430 -0.380353577  0.1797550122
      212  0.506189864 -0.592372270  0.122672514  0.080904417 -0.0654836627
      213  0.053127795  0.087471901  0.229753546  0.118828937 -0.1600526190
      214 -0.015651772 -0.636859596  0.171715065  0.983458306 -0.0886234387
      215 -0.764939949  0.550615749 -0.046128632 -0.036255932  0.1339213040
      216  0.222646081 -0.453182273 -0.005230678  0.400058199 -0.0293389410
      217 -0.284153970  0.136554881 -0.082418631  0.618561376 -0.2098389112
      218  0.052217859  0.305708222  0.066769778 -0.613050319 -0.2342932845
      219  0.711893477  0.636169839 -0.039492501 -0.813694849 -0.1606121711
      220 -0.724227131  0.639078923  0.199983259 -0.221679341  0.1465535537
      221 -0.339695744 -0.010969072  0.118261042 -0.620420730 -0.2472826074
      222 -0.014773814  0.115775011  0.273110212 -0.603558171  0.0206039653
      223 -0.031137023  0.169502364 -0.205501855  0.114779248  0.2202155235
      224 -0.098802359 -0.090553577 -0.287478981  0.061235206 -0.0855248934
      225 -0.099868244  0.085776625  0.129871718  0.907195527  0.1385688606
      226 -0.494860677 -0.705592030  0.241538435  0.283413880  0.0518855929
      227  0.698298992 -0.386239453  0.049423974  0.324377716  0.0538722120
      228 -0.559268879 -0.450091696  0.169618957 -0.345876753 -0.0805375308
      229  0.436604089 -0.583940624 -0.015116181 -0.386659131  0.2546725820
      230  0.490724133  0.078918373  0.041447001  0.643072403  0.2239231260
      231 -0.441667066  0.506410362  0.038652812  0.128261503 -0.2111343880
      232 -0.290126258 -0.645900376  0.213890304  0.548826689  0.2234532566
      233 -0.372577017 -0.425167333  0.141312174  0.398584320  0.1122177941
      234  0.032500435 -0.201962098  0.241171749  0.064325382 -0.1717733971
      235 -0.468350635 -0.441698988 -0.215623702 -0.324416183  0.1582258462
      236  0.238892000 -0.234352851 -0.223925523  0.430706293  0.2009209061
      237 -0.351989840  0.603146949  0.113251002  0.633969375  0.2214016474
      238 -0.145379375  0.006738259 -0.179592312 -0.791832358  0.0549960910
      239  0.527410943 -0.492674807  0.018127232  0.638925319  0.0171694456
      240 -0.103918526  0.597804415  0.241025482  0.611042829  0.0480635478
      241 -0.388313632  0.152452000  0.043517114  0.842739206  0.0584946823
      242  0.557730183  0.639968177  0.274534544  0.680952828 -0.1974340057
      243 -0.442033998  0.168461902 -0.174689249 -0.417352029 -0.1329059971
      244 -0.494624137 -0.263363230 -0.217027324  0.356051839 -0.2072914705
      245 -0.753497109  0.619815262  0.013567134  0.250281226  0.1145537298
      246 -0.057063289  0.641176508 -0.167067396  0.903258380  0.1473249985
      247 -0.321196396 -0.429008342  0.208834166 -0.783038528 -0.0787613000
      248 -0.490799295  0.269687082  0.012570867  0.743643139  0.2648192822
      249  0.262405884  0.020752111 -0.258011656  0.998549530  0.2485416538
      250 -0.345597279  0.658546421 -0.221167614  0.646383653 -0.0391959972
      251 -0.441451920 -0.278554263 -0.168486627 -0.637987238  0.1009760903
      252 -0.017261992  0.152081005 -0.214607668  0.080247701  0.1809825797
      253 -0.433375461 -0.599328486 -0.243752057  0.652843346 -0.2620689363
      254  0.503391346 -0.007556243 -0.301237520  0.903631582 -0.1779163810
      255 -0.186780921 -0.477528569 -0.224079446 -0.168331250  0.1510448165
      256  0.197078958  0.301006794  0.178582236 -0.854439103  0.0775426661
      257  0.708501937 -0.454302195 -0.145571467 -0.248524545 -0.0517750867
      258  0.434379301 -0.440075660  0.078987540 -0.330253553 -0.2728525699
      259 -0.620026583 -0.437321660 -0.025431622 -0.480745531  0.0480482952
      260 -0.426692351  0.297483827  0.119308385  0.757143947 -0.0186717556
      261 -0.446999858 -0.130203827 -0.131802388  0.235445443  0.0784956202
      262  0.301877649  0.299293827  0.189690919 -0.540662031  0.1605093717
      263  0.150160525 -0.093678191  0.081012023  0.655438749  0.1339492932
      264 -0.349924065 -0.430637388  0.285365189  0.571333586  0.0710932228
      265 -0.091750598 -0.052166129 -0.108943793 -0.376155721 -0.1350180061
      266  0.622579356  0.169071900 -0.249684679  0.572994240 -0.1885047094
      267 -0.703079130 -0.344543328  0.054403681 -0.877196712  0.1579048344
      268  0.256304107 -0.226040409  0.038015126 -0.545918778  0.1633848813
      269  0.515811850  0.243538651 -0.150549780 -0.047633678  0.1060098473
      270  0.394188477  0.120231794 -0.034463825  0.768971566  0.0757112264
      271 -0.733575605  0.527309076 -0.250604740 -0.542339888  0.2023553647
      272  0.226990736  0.542760905 -0.041052584  0.436392747  0.0357182961
      273  0.725509995 -0.587144529  0.296657367  0.267329450  0.2241543338
      274 -0.221068907  0.491679610 -0.117608782 -0.650776705  0.0826593836
      275  0.737561785  0.070197341  0.210263158  0.079940642 -0.2474466098
      276 -0.014702906  0.678548987  0.241192298  0.472464372  0.0942452901
      277  0.677132675 -0.102534984 -0.139799798 -0.691072842 -0.0279867012
      278  0.157337217 -0.165539884 -0.192993902 -0.702261785 -0.2324378523
      279 -0.234850391 -0.019356147 -0.285186292 -0.708006125  0.2547799794
      280 -0.649802481  0.167521413 -0.032177005  0.138059355 -0.0979153601
      281 -0.502322510 -0.131188772  0.107173613  0.112376651 -0.2462499416
      282 -0.615310893 -0.710378302  0.102964192 -0.021367031  0.2605764927
      283 -0.209865890  0.500335233  0.221558197  0.925387951  0.0807819710
      284 -0.773232018 -0.122800725 -0.075781842  0.243888295 -0.1602299466
      285 -0.663559448 -0.675413597  0.200276062  0.875567501 -0.1660794324
      286 -0.317241620 -0.108060178 -0.260027143 -0.589545209 -0.0237582822
      287  0.133501743 -0.140620936 -0.001507401 -0.525046142  0.1017962987
      288  0.317002094 -0.118880734  0.019981142 -0.577378066 -0.0892560685
      289  0.388918270  0.309744677 -0.020685160 -0.699273184 -0.1430818079
      290 -0.293589296 -0.213023836 -0.204949143 -0.517960639 -0.0008485668
      291 -0.179875150 -0.220652229 -0.158484357 -0.249886453  0.1318459764
      292  0.765575585  0.283440090  0.274837972  0.203188442  0.1143785346
      293  0.281979661 -0.140012832 -0.270410690 -0.521467997 -0.2167013368
      294  0.609834729 -0.323027742  0.146170334 -0.578506475 -0.2459627289
      295 -0.286086837 -0.472481567 -0.082190720 -0.818992804 -0.1195643444
      296 -0.061475610 -0.720126324  0.041033242 -0.153671899  0.0873369950
      297 -0.150447947 -0.336283474  0.091960734 -0.380904740 -0.0929702210
      298  0.667508123  0.681295791 -0.113667810 -0.028957908  0.1967970169
      299 -0.273326400  0.028353431 -0.070638181  0.463580308  0.1689234692
      300 -0.612706105  0.432401673 -0.020783251  0.643081211  0.0327999521
      301 -0.366462808 -0.361693789 -0.157336906 -0.879587982 -0.2274600715
      302 -0.415557124  0.040538094  0.021294910 -0.664275321  0.0610129747
      303  0.155104370 -0.519087234  0.009344944  0.250054272  0.2190350784
      304 -0.458835990  0.517836934  0.097416715  0.278988660 -0.0944665554
      305 -0.433105156 -0.639062335  0.275752801  0.034405673 -0.0925349618
      306  0.094767605  0.539435931  0.239181140 -0.801793306  0.0427596898
      307  0.419392841  0.218942853  0.090997830 -0.898486495 -0.1105421037
      308  0.207865623  0.367255312  0.124415118 -0.590150035  0.1880761026
      309 -0.247619449  0.189669239  0.098302511  0.447799099 -0.2415547310
      310 -0.475085191 -0.409333908 -0.041407036 -0.492766476 -0.2504077053
      311 -0.783976846 -0.669182166 -0.160655641 -0.591905672  0.2191218693
      312  0.547050438 -0.441948165 -0.144521132  0.801244329 -0.1883071658
      313  0.278419321 -0.116526218 -0.142684456 -0.899743509 -0.0803896047
      314 -0.468348690 -0.699225746 -0.158611596 -0.566762790 -0.0905128126
      315  0.758156628 -0.612904710 -0.201686653  0.731813462 -0.0131310169
      316  0.395304697  0.555323342  0.153947903  0.656927323  0.1425360780
      317 -0.169398233  0.092547284 -0.285888797 -0.544300070  0.1749235684
      318 -0.645785735 -0.406536587 -0.119245499  0.837495003 -0.2167745711
      319  0.152407866  0.243193128 -0.255178743  0.977511656 -0.1720901270
      320  0.275335159  0.471270809 -0.284546284 -0.596011841 -0.0939329309
      321  0.022056795 -0.445749044  0.174826114 -0.407605563  0.2345374991
      322 -0.221778752 -0.537589542  0.270543232  0.717321870 -0.2324212478
      323  0.239009899  0.457153962 -0.058866424 -0.463182939  0.0234127449
      324  0.040855141 -0.216212170  0.181105917 -0.045335073 -0.0901514751
      325 -0.683540262  0.007581060 -0.001307599  0.759945163 -0.0581302062
      326  0.527640517  0.280289498 -0.217768830  0.465998983 -0.0858489854
      327 -0.699275154  0.191886682  0.268463166  0.201454926 -0.0406030616
      328  0.381300953 -0.242037821  0.215805808  0.239337364 -0.0576398938
      329 -0.509620950  0.565966229  0.207888091  0.102019103 -0.0581344911
      330  0.311764959  0.328418839  0.034127606  0.005275772 -0.1925790319
      331  0.440114050 -0.239280847 -0.273050199  0.085292204  0.0957798334
      332  0.403811170  0.352953380 -0.221949010 -0.403807845  0.1852133832
      333 -0.445868267 -0.184550441  0.261627112  0.327275974  0.1195536090
      334 -0.450200272  0.360490318 -0.297296124 -0.742996265 -0.0405054661
      335 -0.629715373  0.352291762 -0.102732038 -0.663349468 -0.1916398069
      336 -0.554636913  0.169812483  0.061870957 -0.457043832  0.0467422561
      337 -0.002733462  0.427813643 -0.208931091 -0.207382148 -0.1184475814
      338  0.343231566  0.580500696 -0.144825279  0.444057938 -0.1091587152
      339 -0.737283871  0.145935988  0.311509272  0.268539312 -0.2009135380
      340 -0.755845026  0.317682170  0.224925940 -0.458222533 -0.1110192798
      341  0.271941909  0.015315932 -0.293578502  0.181929724  0.2291252670
      342  0.684100167  0.402444454  0.098485817  0.626386500  0.1080682669
      343 -0.265065188 -0.105313836  0.042621429 -0.247670448  0.1253840292
      344 -0.699195039 -0.627665869 -0.172572067  0.366881312  0.2565676307
      345  0.410376343  0.631284820  0.158950081  0.013059460 -0.0375628096
      346  0.672074343 -0.642722820  0.031047748 -0.340058801  0.2025044204
      347  0.519430614  0.595061630 -0.209002349 -0.636951470  0.0006477566
      348 -0.507521818  0.498788699  0.184561953  0.865847402 -0.1437784181
      349  0.231720078 -0.516282764  0.073238392  0.174305165  0.2411533452
      350  0.267543569  0.055118415 -0.226987117  0.534259225 -0.1840588533
      351  0.608634818  0.058435024 -0.274770775  0.959179456 -0.1179798455
      352 -0.495736495 -0.163108112  0.190595193 -0.520691713  0.0430566502
      353 -0.012583178  0.052033018  0.093980602 -0.020208781  0.0898413839
      354 -0.582276492  0.604310650 -0.187491723 -0.381913741 -0.1844881393
      355 -0.025791013 -0.047691365  0.256432695 -0.037713909 -0.1347176716
      356  0.160431395  0.451921092  0.184514118 -0.532827324  0.2008246630
      357  0.616178435 -0.187071595 -0.067073208  0.228253051 -0.0526628150
      358  0.220099344  0.317443356 -0.189326216  0.795732749 -0.2687385878
      359 -0.521190340  0.258869285 -0.054611204  0.449106458  0.0381886365
      360 -0.771776311  0.377438686  0.109373096  0.890945834  0.0528775570
      361  0.501148642  0.273577672 -0.093812152 -0.895670285 -0.2512041088
      362 -0.450995357  0.598235750  0.090355853  0.142778298 -0.2533134068
      363 -0.514578239 -0.482093838  0.145101517 -0.808178801 -0.2308238247
      364 -0.767987543  0.561474902  0.026400324 -0.041584267 -0.0998900919
      365  0.068321708  0.394062148  0.162840419 -0.799968683 -0.0599487340
      366  0.036736756  0.618321696 -0.091709367  0.650028418  0.0263790710
      367  0.328030487  0.166392823 -0.093293314  0.518356057  0.1145150524
      368  0.131172978 -0.566974887 -0.093032037 -0.345804556  0.1351364766
      369  0.316517416  0.164622317 -0.292805315  0.765322745  0.0783312056
      370  0.454474043  0.337125281 -0.145623892  0.323719229 -0.1960957656
      371 -0.487315817 -0.151768505  0.263127229  0.795770849  0.0400939737
      372  0.264179975  0.368651627  0.190445495  0.232728601  0.1599500940
      373 -0.118321716  0.059637170  0.224537374  0.300851378  0.2235301682
      374  0.026320848  0.191926680 -0.150914280  0.664243149 -0.1953197543
      375 -0.134829845 -0.638483587  0.041072301 -0.919314186  0.2311035496
      376  0.782250185 -0.700698862 -0.099228700  0.515727363  0.1948996846
      377 -0.128879297  0.280161768 -0.126521101  0.035143534  0.0033692042
      378  0.403690696  0.148992399  0.074678204  0.337976883 -0.1759744019
      379  0.716858832  0.432994721 -0.296735061 -0.697555658 -0.1267247689
      380 -0.570334394 -0.376709496 -0.176165909 -0.271726044  0.0829194530
      381  0.123988494 -0.049639146 -0.249541249  0.693716933 -0.1979481578
      382 -0.185820856 -0.472899132 -0.052988827 -0.636009870 -0.0670251348
      383  0.306075144  0.087218900  0.208124430  0.860415720  0.2654061859
      384 -0.570198255  0.650053703  0.138470012 -0.056732247  0.1688034690
      385  0.668994860  0.212562932 -0.278865430  0.130224625  0.1196842713
      386  0.287549955  0.226767053 -0.249833717  0.985925173 -0.0587958462
      387  0.221383966 -0.299523869  0.059371256 -0.730217045  0.2494796653
      388 -0.597410185  0.695884723  0.217107222 -0.672896794  0.0591825857
      389 -0.488208189 -0.454773262  0.178502669 -0.498951246 -0.1425210192
      390  0.649593615 -0.369586995  0.112654560  0.039224218 -0.0990498112
      391 -0.010967805 -0.559147149  0.147062928 -0.578632226 -0.1617499180
      392 -0.388585666  0.248888425 -0.067736548 -0.506834930  0.2592618885
      393 -0.419325327 -0.328816167  0.292359478  0.840414386  0.2431861716
      394  0.606696926  0.359239204 -0.127557840 -0.703788455 -0.0876795131
      395  0.745602078  0.094876209 -0.130662619 -0.091960182  0.2355947167
      396  0.321610908  0.415506805 -0.063778113  0.959091186 -0.2125385923
      397 -0.322727238  0.074880737 -0.034823342  0.585957942 -0.0427683310
      398 -0.553040409 -0.388560890 -0.225111930 -0.560729984  0.0295113593
      399 -0.018284797  0.387934962  0.127418731  0.752961407 -0.0953836150
      400 -0.609839546  0.388303687  0.052566259 -0.648105294  0.2151849604
      401 -0.104233391  0.007371247  0.238196014  0.449882770 -0.2124496866
      402  0.510321904 -0.371480549  0.207846226 -0.415223271 -0.2322564477
      403 -0.656803832  0.074329382 -0.115678572 -0.281020028  0.1801665600
      404  0.579105904 -0.240807625 -0.031013201 -0.660002897 -0.1021711338
      405  0.255991024 -0.143944275  0.004780079 -0.433506050 -0.0381638359
      406  0.722725017 -0.404550764  0.143885384  0.251779065 -0.1316557332
      407 -0.450383791 -0.399558910 -0.141886123  0.093597041 -0.1058465537
      408  0.510986061  0.102779389  0.079244392 -0.382221317  0.2048917684
      409  0.606189612  0.139758730  0.048359499  0.956990879  0.0476035973
      410 -0.411971028 -0.151095400 -0.276372649  0.883442721  0.0727759485
      411  0.492443443  0.230973169  0.121966637 -0.602905384  0.1896373731
      412  0.116536640 -0.656096436  0.008132589 -0.138450608 -0.2000499512
      413 -0.065185334  0.627411068 -0.035081244  0.987417196  0.1416319048
      414 -0.706802911  0.287565955 -0.144761239  0.249293452  0.1080954807
      415  0.181764346  0.615418641  0.103700149  0.027869118  0.0403931230
      416  0.773466344 -0.316803589  0.297778636 -0.151658742 -0.1450085385
      417  0.121077594 -0.396255711 -0.129299680 -0.689850996 -0.0729833708
      418 -0.254720214  0.005800535 -0.204587359  0.671705363 -0.0751142423
      419 -0.099870200  0.135595595 -0.290058456 -0.185011695  0.1725336515
      420 -0.451339933  0.231890338  0.116583297 -0.884341619 -0.0009206318
      421  0.686277897 -0.430727556 -0.265224969 -0.067470096 -0.0025598065
      422  0.737430256  0.091770064 -0.299640812 -0.732678007  0.0678666494
      423 -0.763994975  0.553600746  0.290087002  0.620581598 -0.1905803900
      424 -0.156786965 -0.246302438  0.153683400  0.444017744  0.2607906254
      425  0.352167808  0.333212414  0.253672840  0.315745328  0.0683200311
      426 -0.065819821 -0.312272220  0.028794631  0.556814481 -0.1180201600
      427  0.025186820  0.337254053 -0.275333834 -0.164720691 -0.0086612536
      428  0.513725827 -0.085925609  0.178189284  0.291003001  0.2376718123
      429  0.630549374 -0.436963048  0.188304091 -0.059835015  0.2301991663
      430  0.395861710  0.285901863  0.078617306 -0.384596805  0.1522125626
      431  0.406818670  0.126173617  0.159499256  0.166326202 -0.0437567393
      432  0.531027917 -0.201121123 -0.215256623 -0.917695584  0.1442845866
      433  0.210596886 -0.038604952 -0.078807272  0.589362663  0.0244401983
      434 -0.088972595  0.224019071 -0.161057586 -0.283177124  0.0445299235
      435 -0.051883106  0.453128184 -0.173987660  0.959621054 -0.1986806562
      436  0.368492972  0.169315639 -0.265129591  0.972046953  0.0529480840
      437  0.273810482 -0.216433267 -0.216226141 -0.438496096  0.2362069838
      438 -0.156631659  0.684440901  0.143832167 -0.701065843 -0.0777905072
      439  0.625397576  0.142028735  0.129869268  0.352673559  0.1844614798
      440 -0.038144999  0.079622195 -0.231170618  0.310362156 -0.2643964569
      441  0.622204382 -0.253107587 -0.296044075  0.449580213 -0.2159812788
      442  0.730629126 -0.052731188  0.180582329 -0.602950475 -0.0767937362
      443  0.164976702 -0.551756029  0.179081663 -0.407638747  0.0241643405
      444  0.108608442  0.410314925 -0.174679506 -0.771234985  0.0564479384
      445 -0.077241258 -0.158707205 -0.173121178  0.847744211 -0.1131042751
      446  0.734732236  0.490168845  0.115217543  0.886560184  0.1094955819
      447  0.448897792 -0.284294615  0.219888564 -0.247057002 -0.1264809400
      448 -0.627544801 -0.224676627  0.084610818 -0.543800206 -0.0301739925
      449 -0.310505096  0.416950120  0.277875345  0.285564673  0.1777589927
      450 -0.427889892 -0.177328600  0.166682986  0.201193714 -0.2380660078
      451 -0.249934403 -0.300941237 -0.159221160  0.649086644 -0.1526534846
      452 -0.340334696 -0.686666087 -0.053403225 -0.502825791 -0.2534778214
      453  0.609125895 -0.222297218  0.169949527  0.800697870  0.2057304771
      454  0.078257649 -0.149847993 -0.051769237 -0.085646746  0.0413174092
      455  0.050591153 -0.556563873  0.042523017  0.886336890 -0.2687559458
      456 -0.251683732 -0.682407274  0.061062563  0.337571004 -0.2628033464
      457  0.347676267 -0.725271194 -0.245605147  0.380637941  0.2171680017
      458  0.330077411  0.135470201  0.284250748  0.506238499  0.0750269825
      459 -0.312366977 -0.151893376 -0.087631020  0.275377437  0.1076477245
      460 -0.157893390  0.672950035  0.191636629  0.978136295 -0.2262918692
      461  0.436981890  0.643203048 -0.213079718 -0.916240653  0.2600776378
      462 -0.102884263 -0.573807735 -0.233180777 -0.042306653  0.2007815258
      463  0.451951087 -0.059175064 -0.005695221  0.915885905 -0.2560467497
      464 -0.252681040  0.300055406  0.244198335 -0.724653328 -0.1215239424
      465 -0.405865355 -0.576295486  0.249290061  0.736748421 -0.0298059304
      466  0.083336062 -0.123121858 -0.224843376  0.432057202  0.0837910159
      467  0.596328876  0.225709348 -0.008310811  0.724832970 -0.1829667354
      468  0.196744488 -0.430407175 -0.208610244 -0.674413630  0.1657859114
      469  0.345536131  0.682180064 -0.010308889  0.168182455 -0.2677861084
      470 -0.537083307  0.637701749  0.102894710  0.959202931  0.1659453279
      471 -0.284301463 -0.621637451  0.092876468  0.119145803 -0.1355995970
      472 -0.229881960  0.673204717  0.190506020  0.651695198 -0.1931162953
      473  0.234116995  0.674866947  0.228170065  0.189923947  0.1314492185
      474  0.131970463  0.279001606 -0.175330748 -0.798105785 -0.1470616097
      475 -0.321751045 -0.614914350 -0.255603938 -0.530824416  0.0947466944
      476  0.063028573 -0.679866194 -0.225567669 -0.526080049 -0.1294897427
      477  0.555614277 -0.097528456 -0.113968474  0.810184397  0.1121637269
      478  0.078878738 -0.556900568 -0.058048406 -0.525295344 -0.0201576739
      479 -0.130157621 -0.283076352 -0.294675853  0.747750068  0.1475922499
      480 -0.434082961  0.612404874 -0.142921674 -0.249012308  0.2639616509
      481  0.356645865  0.484789417  0.179468875 -0.179703663  0.2204932864
      482 -0.708959652  0.430742663 -0.175040568 -0.476620556 -0.1872287919
      483 -0.329039719 -0.290128412 -0.214754298 -0.252570298  0.0787804830
      484 -0.727269059 -0.099093667 -0.075392632  0.435480464 -0.1373214085
      485 -0.759635634  0.064443936 -0.141648368 -0.116034431  0.1182765340
      486  0.312086996 -0.138922844 -0.008978787  0.963219579  0.0332486368
      487  0.153798165  0.127577257  0.277474882  0.851564099  0.0213646654
      488 -0.726689679  0.390692591  0.105190019  0.222215448  0.1176844318
      489 -0.036273516  0.084253629 -0.256837141 -0.220046709  0.1840675231
      490  0.257044129 -0.401649294  0.310065802  0.658147510  0.0414565039
      491 -0.387367210  0.196651694 -0.176268889 -0.059081930  0.2443769629
      492 -0.600480014 -0.725806679  0.194622179 -0.682593720 -0.0387538453
      493 -0.673423958 -0.310067410 -0.080509158 -0.549817876 -0.1132768820
      494  0.250100274 -0.524336557 -0.276253781  0.283520730  0.1741164195
      495  0.013039926 -0.331318733 -0.121544117 -0.261983865 -0.1797286214
      496  0.641009662  0.080195677  0.116784424  0.534431955  0.1000905699
      497  0.325279730 -0.459933112 -0.059734664  0.751788203 -0.0684558956
      498 -0.410217506 -0.199191400 -0.073014123  0.243714747  0.0675455883
      499 -0.458769438 -0.552823554  0.046836271 -0.224699143 -0.0416844656
      500 -0.088361960  0.317709900  0.074533654 -0.307265594  0.0425569990
      501 -0.150300070 -0.264497615  0.163402470  0.094429910  0.1388082484
      502  0.158916490  0.710236534  0.025097141  0.011028834 -0.1785836750
      503 -0.218740685  0.061187893  0.167615449  0.704893089 -0.2094996967
      504 -0.329995972 -0.257377057 -0.117577894 -0.264399568 -0.1205032362
      505  0.459908756  0.636452754 -0.299573901 -0.714667961 -0.1055422780
      506  0.314647742 -0.172233644 -0.180785967  0.569643968  0.2529183657
      507 -0.214116002 -0.026494098 -0.016381142 -0.542994501  0.0722843240
      508  0.080567591  0.004962143 -0.064026054 -0.246249124 -0.1844376198
      509 -0.601576725 -0.167076367 -0.081448855  0.795050882  0.1142438736
      510 -0.552598377  0.289073442 -0.073033044  0.759684336  0.1019030197
      511 -0.550073978 -0.586569326 -0.208493385  0.454267052  0.0113474228
      512  0.270522872 -0.123149725 -0.083701686 -0.711536947 -0.1271423760
      513 -0.048877747  0.550060379 -0.096643791  0.643229739  0.0502552656
      514 -0.343786198  0.530787357 -0.269123609 -0.821844000  0.0802708038
      515  0.463921146 -0.149765582  0.173390544  0.994950590 -0.1026112570
      516  0.441951587  0.683008318 -0.004891285  0.775599172 -0.0482025756
      517 -0.551787949 -0.271125699  0.195125104  0.543876557  0.0356061811
      518 -0.521928570  0.516469341 -0.239368295 -0.484523131 -0.1967157706
      519 -0.093778759 -0.558388631  0.023717257 -0.110459558  0.2492158612
      520  0.242641917 -0.557252461  0.059565158  0.272158526 -0.2457361563
      521 -0.176018120 -0.566515106 -0.213298521 -0.395482203  0.1208548993
      522  0.396255127 -0.178114732 -0.086731593 -0.517955540  0.1809029298
      523 -0.654478603  0.598049295 -0.058045359 -0.034026470 -0.2476868388
      524 -0.783622581 -0.593606257 -0.135963264  0.340136244 -0.0659105504
      525  0.690420901 -0.376747257  0.028658433  0.657560627  0.1903175864
      526  0.244046029 -0.119982673 -0.091820488 -0.615168466  0.1758422494
      527 -0.343436674  0.482040346 -0.032534977  0.444747248 -0.0014743467
      528 -0.125634322 -0.657797613 -0.294232068  0.824722748 -0.1287018876
      529  0.761470945  0.392975694 -0.122859252 -0.344897663 -0.0643971627
      530  0.190903847  0.632207599  0.143108831  0.995843060  0.1576161634
      531  0.448449828  0.270974091  0.136506361  0.331078077  0.1267952992
      532  0.383274460 -0.509830770 -0.084325097  0.597426198 -0.0806167810
      533  0.124312119 -0.078075600  0.305085128 -0.826543881 -0.0703471763
      534 -0.019074275 -0.088465495  0.246597280  0.218586289  0.1341655242
      535 -0.015663119  0.459128845 -0.173725139 -0.150893849 -0.2156052550
      536 -0.663610389  0.004773689  0.229628074 -0.471410232  0.2296386344
      537  0.186204145 -0.629211846  0.310367887 -0.068064897 -0.2668979385
      538 -0.071916879  0.696684462 -0.152013145 -0.719515367 -0.2501245998
      539 -0.577632807 -0.606597593 -0.097084331  0.681546606 -0.0705463390
      540 -0.679390622 -0.413377510 -0.196361788  0.582931372 -0.0866606609
      541  0.435118050  0.236164558 -0.110339667 -0.906855286 -0.0174970575
      542  0.056137164  0.628478082  0.277457791  0.494001085  0.1321920175
      543 -0.015648298  0.243293253 -0.135388197  0.371982829  0.0754118308
      544 -0.118831502 -0.205788921 -0.181601680 -0.222128435 -0.2213788801
      545 -0.500087378 -0.168281209  0.168571171 -0.191407605  0.1764129275
      546  0.557268117  0.274735030  0.118663668 -0.238549847 -0.0268873930
      547  0.242448027 -0.588593916 -0.296153974 -0.864359651  0.1386642138
      548  0.589618859  0.166211116  0.071844092 -0.721403692  0.0714465877
      549 -0.590902565 -0.488770745  0.006989568 -0.209018394  0.1525259769
      550 -0.355357495 -0.237780513  0.290616783 -0.803622190 -0.0159382914
      551  0.115458026 -0.292407348 -0.168937365  0.324446758 -0.2110614600
      552  0.630264857  0.689306421  0.288626397  0.505488494 -0.2574142421
      553  0.133346950  0.536725672  0.288572949 -0.688129253 -0.2544655543
      554 -0.578693188 -0.092687704 -0.137458706 -0.907038679 -0.0575976502
      555 -0.556558723  0.498882831  0.064240100  0.738548422  0.1253260739
      556  0.332279969  0.621039735  0.151370208 -0.591835149  0.0056409204
      557 -0.048899082 -0.420053134 -0.183155162 -0.328533008  0.2369803782
      558  0.150507215  0.050883150  0.209123831 -0.480041819  0.1159789009
      559 -0.695859469 -0.121103288 -0.086107460  0.032341597 -0.0918061611
      560  0.615498730 -0.626577713 -0.116585083  0.299603666  0.0368391132
      561 -0.598730789  0.345630706  0.019749456 -0.487843693  0.1550309231
      562  0.486221496 -0.440540740 -0.145100186 -0.147427876 -0.1830997791
      563 -0.762811747 -0.728084610 -0.170232587 -0.549708995  0.0954755144
      564  0.779929360  0.197114972 -0.076324418 -0.155808193  0.0843860253
      565  0.208333227 -0.601790962 -0.118609784  0.001720992  0.0648031598
      566 -0.431385257  0.202629834  0.201751155  0.902694010  0.2660258564
      567  0.496816565 -0.645566489  0.157131728 -0.648502627 -0.1545555160
      568 -0.427572358  0.655289128 -0.199520389 -0.460643667  0.2393289157
      569  0.569601921  0.667867236  0.231490389  0.166863173  0.1173166209
      570  0.132380386  0.205541184 -0.023517610  0.478590302 -0.1456917019
      571 -0.676733669 -0.618515954  0.244317626  0.481690697  0.2463017821
      572  0.315094050 -0.328795438  0.272809943 -0.517696905 -0.2372997121
      573 -0.175501546  0.286074091  0.276412934 -0.073008107  0.2084815689
      574  0.486674299 -0.663434964 -0.177549980 -0.066602387 -0.2147809411
      575  0.471673168  0.019350381  0.067950295  0.921768004  0.1507902717
      576  0.034375549  0.109816641  0.066907367 -0.584349818  0.2034438279
      577 -0.631740113 -0.159798438  0.275102264  0.327418209  0.2524578219
      578 -0.240622732 -0.018896683 -0.092980042 -0.578886948  0.1683077747
      579 -0.194606493 -0.636945345 -0.298736202 -0.805152855 -0.0890614018
      580 -0.196491408  0.481961988  0.057881087 -0.037367346 -0.1027490099
      581 -0.224459871 -0.344256652  0.311653820 -0.499058404 -0.0359695748
      582 -0.060550048  0.339562591 -0.276800490 -0.470633038 -0.2559398930
      583  0.660015481 -0.239689385 -0.023369527 -0.909135626  0.2182978933
      584 -0.711894601  0.193614739  0.143951395  0.506722809  0.0477471993
      585 -0.160139822 -0.047106361  0.295153731  0.612671336  0.2135656128
      586  0.740159210  0.362157728 -0.223679026  0.728441347 -0.0010190735
      587  0.234913034 -0.115966372  0.206426160 -0.036732869  0.0001259274
      588  0.027930249 -0.462352353 -0.147488731 -0.710204028 -0.2284384707
      589  0.312808335 -0.112905301  0.161872813 -0.152587956  0.1213749368
      590  0.459424330  0.465599586  0.171235558  0.775407674  0.1329698029
      591  0.360876983 -0.169137103  0.229522769 -0.841978385 -0.1472491308
      592 -0.099504341  0.482388139 -0.269679625  0.450490850 -0.2703841600
      593 -0.206737565 -0.146818029  0.241235997 -0.470763990 -0.0326610006
      594 -0.095860212  0.449302546 -0.125760541  0.301521795 -0.1636596096
      595  0.425622192 -0.589064904  0.153578270  0.739240044 -0.2256787333
      596 -0.571484380 -0.245511019  0.033394957 -0.245686292 -0.2025073286
      597 -0.193907394  0.269649401  0.202314895  0.215584258  0.0764715019
      598  0.602160580  0.375354277  0.103003543  0.596065086 -0.1414059664
      599 -0.147390576  0.231901609 -0.289245880 -0.617073009 -0.1224691470
      600 -0.482433744  0.699883319  0.234048997 -0.611877315  0.2060553172
      601 -0.596219128 -0.625309344  0.224873753 -0.721972457  0.2076114845
      602  0.040531950  0.444537398 -0.269608909 -0.661322607 -0.0862838659
      603 -0.150772554  0.162197020 -0.278136696  0.438943602 -0.2721843219
      604 -0.124847765 -0.032819154 -0.292157430  0.579152431 -0.1380904778
      605  0.598367079  0.164920869  0.071578916 -0.565157179  0.0351970062
      606 -0.434684478 -0.487493846  0.210115100 -0.343342357 -0.2561932288
      607  0.127350250  0.201257747  0.254396063  0.012700290 -0.2501455712
      608 -0.250993652  0.266434146  0.155006871  0.994062451 -0.2518061010
      609 -0.029188658 -0.145828181  0.237825514 -0.374877885 -0.1687024235
      610 -0.512719771 -0.382308382 -0.296878298 -0.397775916 -0.0154905776
      611 -0.527189676  0.450477510 -0.121830408  0.288980955  0.2168503028
      612 -0.086242025  0.227176255  0.291270824  0.373916879 -0.0506337994
      613  0.339376673  0.371688763  0.160241122 -0.695463892  0.2562460112
      614 -0.688683211  0.649069778 -0.277625776  0.266784370 -0.1736507609
      615 -0.624474879 -0.039544800  0.024172326  0.617931469 -0.1349841675
      616 -0.382240373  0.560177052  0.217174890 -0.745757868 -0.0287069665
      617  0.557407203  0.689592185  0.051506712  0.749445705  0.0918887277
      618  0.079732944  0.570989619  0.261655334  0.723944398  0.1790310526
      619 -0.265662633  0.468518121  0.043860949  0.464441888  0.0460474935
      620  0.257634295 -0.464809164  0.153127160 -0.211852576  0.1389214447
      621  0.146717785 -0.289300234 -0.045534627  0.946450006 -0.0738962212
      622 -0.246065390 -0.077161294  0.282120039 -0.362649352  0.1823006499
      623 -0.304057977 -0.318316392  0.250336751  0.239329060 -0.0831105149
      624  0.376391344  0.047772035 -0.082959739 -0.193442977 -0.1255363552
      625 -0.718240927  0.615914256  0.057670728 -0.923320075 -0.1690629888
      626  0.538086428  0.230821112  0.016618674 -0.624700505  0.1600661319
      627  0.312169748 -0.412040988  0.192703862  0.263335141 -0.0544434933
      628  0.063951834 -0.393170418  0.139057235  0.839087631  0.1914672181
      629  0.691481393  0.080486012  0.029729679  0.483500420  0.1173740401
      630  0.173581694 -0.658051942 -0.083944090  0.389581867  0.0274115909
      631 -0.776985802 -0.032470244 -0.168173919 -0.096278044 -0.0329744186
      632 -0.383635581  0.086511381 -0.264262358 -0.174893650 -0.1916169434
      633 -0.094811192 -0.151909541  0.192253653  0.634176768 -0.0735617373
      634 -0.470059764  0.201954242  0.088578604  0.622187521  0.1272801056
      635  0.756702040  0.522555888 -0.285784343  0.537076869  0.1905663748
      636 -0.333980651 -0.492880160  0.157384532 -0.661850568  0.2337354315
      637 -0.214656855  0.295559307  0.081618684  0.191188056 -0.1930174014
      638 -0.724172570  0.338392630 -0.273515696  0.266614991  0.1247812141
      639  0.527835871 -0.047726566  0.118659800 -0.934646453  0.1942051738
      640 -0.299752630 -0.146110250  0.210513610 -0.399889355 -0.1310724806
      641  0.237478807  0.494095902  0.290615144 -0.014929474  0.0257139728
      642  0.421570815 -0.660770370 -0.130089158 -0.814020081  0.1710245984
      643 -0.308286600  0.141582565  0.182877641 -0.848203228 -0.0078175947
      644  0.779628134 -0.198861457 -0.247932919  0.793969316 -0.2591839395
      645 -0.556761448  0.141052068 -0.001783839  0.373727350 -0.0065062730
      646 -0.739864260 -0.301648902  0.081589012 -0.575256841 -0.0534146462
      647  0.027000175 -0.045261472 -0.216165314 -0.547821425  0.2460041159
      648 -0.787130888  0.348284460  0.151737885 -0.634597099  0.2099887100
      649 -0.541691194  0.109233852 -0.086476319 -0.351553001  0.1334511913
      650  0.446439570  0.016259438 -0.051719335  0.420966641  0.0268250098
      651 -0.385610797  0.228572170 -0.169860710  0.620716625 -0.0071681803
      652  0.398907561 -0.234606567 -0.185192000 -0.629120291  0.2532380979
      653  0.057028283 -0.395829807  0.305766266  0.539953814  0.0172964362
      654 -0.338087818 -0.705571433 -0.178809070  0.653710322  0.0218964932
      655  0.009400660  0.190578601 -0.298526114 -0.812137365  0.2271150298
      656 -0.503811050 -0.537258569 -0.043439862 -0.899908104 -0.1090307121
      657 -0.702197413 -0.342830254  0.085965332  0.362375110 -0.2364285971
      658 -0.573455669 -0.640964730  0.105224649 -0.505732106 -0.2716055305
      659  0.289689904  0.261586791  0.299717071  0.360506305  0.2274853690
      660  0.605071806  0.127104726 -0.218846040 -0.845751150 -0.1504940397
      661 -0.141387621  0.376992953  0.155237617  0.025106051 -0.1407297817
      662  0.361640067  0.283155708  0.094937849  0.122361924 -0.0773901277
      663 -0.267603903 -0.421606190 -0.058015069  0.591228825  0.0267224206
      664  0.598346935  0.642108797  0.156307075 -0.492855269 -0.0341337819
      665  0.639238224 -0.318714407 -0.136703038 -0.865200533 -0.1663954954
      666 -0.092847965  0.291709490  0.142787845 -0.565373492  0.0626927876
      667 -0.285191807  0.397754401 -0.244657156  0.959454824 -0.1699542684
      668  0.779330716 -0.033191832 -0.017097915 -0.139750428  0.0776495146
      669 -0.646054156 -0.098430647  0.159448645  0.006861217  0.0598752239
      670  0.287051863 -0.385676121 -0.117423502  0.480582961 -0.0349594167
      671  0.708731958 -0.678759989 -0.078430494  0.982120107  0.0273003056
      672 -0.008006929  0.469361531 -0.053165019 -0.676278394 -0.0954880542
      673  0.320433709 -0.688230314 -0.057779831 -0.824601262  0.0640293711
      674  0.425022332 -0.246187780  0.022403705  0.268092733 -0.1522099943
      675  0.534438502  0.698151473  0.310513456  0.289475917  0.1634664518
      676 -0.404131536 -0.032376598  0.177331802  0.887074779 -0.2616896354
      677  0.208199481 -0.265078125 -0.123287057 -0.765459966 -0.1285511802
      678  0.217717910 -0.065830924  0.234747902 -0.896955673 -0.1419712247
      679 -0.559992324  0.291070365 -0.054903073 -0.135131253 -0.2341050201
      680 -0.338105080 -0.583662134  0.254845519  0.617278815  0.2095493778
      681 -0.027914866  0.228432003 -0.300174180  0.961418391 -0.0086199132
      682 -0.144268653  0.533705410 -0.073537484  0.241663197  0.1100590506
      683 -0.633628189 -0.568669723 -0.013175627  0.387149988  0.2169105231
      684  0.221943863  0.229175188 -0.177045445 -0.857325886 -0.2052649621
      685 -0.495844962 -0.259335296  0.142208213 -0.247241377 -0.2196797441
      686  0.693819910 -0.690227289  0.228505902  0.012324972 -0.1895854307
      687  0.322037157 -0.472149841 -0.198552333 -0.905204894  0.1990643250
      688  0.622560764  0.310817975  0.287782716 -0.908213433  0.1858796014
      689  0.522949249 -0.406661395  0.262758780 -0.397558645  0.1930442489
      690 -0.203668770 -0.273214194 -0.073457589 -0.358908601  0.1200116227
      691 -0.153932820  0.088719398  0.226313345  0.057934755 -0.1020720899
      692  0.501264699 -0.317844791 -0.099979146 -0.160603646 -0.2252802700
      693  0.477791284  0.221591289 -0.267800515  0.450545571 -0.1184493991
      694 -0.034757942 -0.087376371  0.082464304  0.077610393 -0.0080722313
      695 -0.395452943 -0.671822468 -0.226289532  0.687133828 -0.1453654724
      696  0.753705238  0.484648761  0.012113336 -0.252317068 -0.1667481225
      697 -0.302794340  0.313528170  0.211942381 -0.778146914 -0.2054226411
      698 -0.710769114 -0.217144458 -0.058918632  0.583030106  0.0525267054
      699  0.731428061 -0.028008793 -0.011201324 -0.371573796  0.0016726081
      700 -0.693931047  0.585969527 -0.135598513 -0.593853856 -0.1147935982
                     x6            x7            x8            x9           x10
      1    5.566042e-04  2.264921e-04 -1.543385e-03 -9.408157e-04 -8.043299e-04
      2   -3.997476e-04 -9.383013e-04 -1.931769e-03  1.896923e-04  2.002264e-04
      3    4.560863e-04 -2.043715e-04 -3.718534e-04 -7.278823e-04 -1.274063e-03
      4    3.029882e-05 -6.270324e-04 -1.900189e-03 -9.803119e-04  2.014658e-03
      5    1.142412e-03  5.802827e-04  1.820922e-03  9.285208e-04  8.597262e-04
      6    2.096491e-04 -1.027100e-04  1.653021e-03 -3.016773e-04 -8.363059e-04
      7    7.500921e-04  1.008420e-03  1.369678e-03 -1.119151e-03 -1.738263e-03
      8   -4.152225e-04  7.419433e-04  1.362465e-03  9.052341e-04  1.488933e-03
      9   -3.699993e-04 -1.393993e-04  1.128897e-03  1.283570e-03  1.957007e-03
      10   1.438554e-03  1.469723e-04  4.959361e-04 -3.895243e-04 -1.774712e-03
      11   1.962975e-04 -3.221995e-04  1.503066e-03 -1.005716e-03 -8.786702e-04
      12   1.557747e-03  3.127231e-04  1.378031e-03 -1.152779e-03 -5.292290e-04
      13  -1.459955e-03 -8.812692e-04  1.187672e-03  6.742948e-04 -9.473019e-04
      14  -1.516294e-03 -7.810508e-04 -1.678080e-03 -3.109939e-04  1.448477e-03
      15   5.320651e-04  1.745492e-04 -1.166467e-03 -8.026462e-04  4.505775e-04
      16   1.564936e-03  5.920247e-05  3.054272e-04 -1.273107e-03  8.329314e-04
      17   4.902031e-06 -8.936403e-04 -4.401432e-04  1.136843e-03  1.882130e-03
      18  -1.184845e-03  5.820652e-04  5.474033e-04  1.256624e-03 -1.514242e-04
      19   1.259782e-03 -7.375161e-04 -6.654706e-04 -1.803585e-04 -1.096978e-03
      20   1.186367e-03  8.261470e-04 -4.295461e-04 -1.252616e-03 -2.101401e-05
      21  -1.063580e-03 -5.176339e-04 -2.107774e-03 -2.038737e-04  6.191422e-04
      22   1.579057e-03  8.928919e-04 -5.454480e-04  9.025507e-04  1.808677e-03
      23   8.770445e-04 -3.539220e-05 -1.724779e-03 -1.634234e-04 -1.882376e-03
      24   8.989437e-04  9.251045e-04 -9.549897e-04  1.298117e-03 -1.511906e-03
      25   8.767975e-04 -4.221556e-04 -5.809517e-04 -1.372801e-04 -1.096399e-05
      26  -1.420581e-03  5.537091e-04  1.506962e-03 -2.615700e-05 -9.888560e-04
      27   1.545046e-03 -5.098386e-04  1.760621e-03 -1.316474e-04  2.427311e-04
      28   2.722202e-04  5.998508e-04 -4.635826e-04  7.418826e-04  1.256302e-03
      29  -8.586131e-04 -8.792059e-04  1.705947e-03  8.741231e-04 -9.288073e-04
      30  -1.472365e-03 -3.883673e-04  1.310730e-03  2.687586e-04  2.971149e-04
      31   3.277090e-04  3.984396e-04  7.246621e-04  1.138036e-03 -9.776454e-04
      32  -7.489273e-05 -9.402023e-04  2.598870e-04  3.685147e-06  1.063606e-03
      33   1.187878e-03 -8.915793e-04  6.730130e-04 -9.068336e-04  1.246869e-03
      34   1.512863e-03  2.568243e-04  6.071531e-04 -3.101566e-04  5.125964e-04
      35   8.999539e-04 -8.088995e-04 -1.246592e-03  5.738621e-04 -1.602811e-03
      36   1.034665e-03 -1.032485e-03 -7.153241e-05 -2.713748e-04 -8.799087e-04
      37   6.059796e-04 -6.367769e-05 -9.184590e-04 -1.235414e-03 -1.807854e-03
      38  -1.227713e-04  1.002994e-03  2.041945e-03  6.501756e-04  1.172091e-03
      39  -2.529543e-04 -9.715139e-04 -1.743960e-03  1.111404e-03  2.780624e-04
      40  -1.523048e-03 -4.730300e-04  1.963475e-03 -1.184899e-03 -6.646633e-04
      41  -1.052266e-03  9.725654e-05  1.387949e-03  3.757544e-04  9.326304e-04
      42   4.660956e-04  8.783834e-04  1.822716e-03  1.761906e-04 -6.943110e-04
      43   1.307585e-03 -7.625163e-04  9.697114e-04  8.729289e-04  2.785155e-04
      44   4.328495e-04 -8.940375e-04 -1.972947e-03 -6.946143e-04  1.258875e-03
      45  -1.396642e-03  1.024487e-03 -4.001896e-04  8.990309e-04 -1.509882e-04
      46  -1.596029e-03  3.101298e-04  6.308958e-04  1.964463e-04 -3.714282e-04
      47  -3.472405e-04  1.082330e-04  1.862874e-03  1.036786e-04  9.899517e-04
      48  -1.190681e-03  2.922781e-05  1.466455e-03  1.332670e-03  4.002675e-04
      49  -9.113212e-04 -3.819522e-04 -8.141935e-04  3.469984e-04  1.048557e-03
      50   3.425424e-04  1.025963e-03  1.781187e-03 -1.319881e-03 -1.617348e-03
      51   5.292672e-04 -7.630400e-05  1.708649e-03  1.121080e-03  1.950737e-03
      52  -1.250239e-03  1.060820e-03 -1.579435e-03 -1.251738e-03 -1.807487e-03
      53   1.309953e-04  1.704795e-04  8.723673e-04  1.137683e-03 -9.569558e-05
      54   7.785418e-04  5.296908e-04  5.404982e-04 -3.613941e-05 -1.409742e-03
      55   1.282881e-03 -1.181099e-03 -3.247167e-04  6.304388e-04 -8.455969e-05
      56   5.372080e-04  6.986180e-04 -1.515452e-03  6.848480e-05 -1.395185e-03
      57  -9.630611e-04  1.017767e-03 -2.139119e-03  5.758090e-04 -9.159353e-04
      58  -4.760320e-04 -1.030266e-03  1.790531e-03  3.342541e-04 -1.671258e-03
      59   5.427274e-04 -2.976569e-04  5.598802e-04 -7.769345e-04 -5.405487e-04
      60  -8.586374e-04 -1.208332e-04 -2.097358e-03 -7.577209e-04  8.030375e-04
      61   2.713066e-04  9.418858e-04 -3.819882e-04  5.722449e-04  1.657964e-03
      62  -8.969803e-04 -7.651993e-04 -6.440029e-04  3.831902e-04  8.514388e-05
      63  -1.150163e-03  7.080415e-04 -4.837590e-04 -6.504933e-04  7.494561e-04
      64   3.825083e-05  1.085595e-03  1.519181e-03 -3.725712e-04 -3.652340e-04
      65   9.694796e-04  1.046617e-03  6.883065e-04 -6.544321e-04 -6.003995e-04
      66   1.223628e-03  5.055737e-04  1.942500e-03 -2.476012e-04 -9.023027e-04
      67   5.984294e-04 -9.083317e-04 -1.264629e-03 -1.106144e-03 -1.080733e-04
      68   1.383627e-03 -1.095021e-03  1.395173e-03  2.264928e-04  5.623025e-04
      69   7.047433e-04  8.293895e-04 -5.492906e-04  7.894931e-04 -1.539882e-03
      70  -7.382019e-04  4.935950e-06  3.468602e-04  8.457839e-04 -1.780536e-03
      71   8.778180e-04  2.814685e-04 -1.955057e-03  1.253690e-03  9.833258e-04
      72  -1.089281e-03  4.763764e-04 -1.670845e-03  4.017423e-04 -1.469273e-03
      73  -4.069132e-04  2.262620e-04 -1.225235e-03  7.214215e-04  1.989649e-03
      74  -4.252807e-05  5.671527e-04  1.907045e-03  8.959201e-04 -5.603512e-04
      75   1.398479e-03 -7.176772e-04  4.827611e-04  1.735707e-04  1.158513e-03
      76  -1.310254e-03  5.462659e-04  1.580146e-03  1.654013e-04 -1.850607e-03
      77   1.558015e-03  6.471797e-04  1.175812e-03  1.235450e-03 -2.593324e-04
      78  -5.674920e-04 -4.042496e-04  3.124541e-04 -6.016062e-05  1.994374e-04
      79   6.300981e-04  1.344049e-04  7.338992e-04 -5.677830e-05 -7.154815e-04
      80  -1.565681e-03 -5.384725e-05 -1.530158e-03 -5.779101e-04 -1.791972e-03
      81  -1.216571e-04 -3.646606e-04  3.509892e-04  3.602240e-04  6.171002e-04
      82  -5.235937e-04  4.728753e-04  1.217128e-04  5.032665e-04 -8.244071e-04
      83  -1.155077e-03 -8.951501e-05  1.510475e-03 -8.597268e-05  1.371126e-03
      84   1.273654e-03 -2.333061e-04  1.551795e-03 -3.478142e-04 -9.997475e-04
      85  -9.609433e-05 -9.663041e-04  6.574839e-04 -2.274989e-04  7.356160e-05
      86  -1.100895e-03 -6.035394e-04  1.875572e-03  4.924662e-04 -5.111661e-04
      87  -2.782247e-04  9.665557e-05  1.357098e-03  1.149496e-03 -5.894555e-04
      88   9.427729e-04  4.540352e-04  4.931065e-04 -1.272067e-03 -1.790713e-03
      89  -1.326502e-04  4.857294e-04 -1.511703e-03  8.377883e-04  1.221005e-03
      90  -4.359892e-04  4.571130e-04  2.012425e-03 -7.718558e-04  1.873166e-03
      91  -3.747379e-04 -3.306627e-04 -1.816843e-03  1.266903e-03  1.931246e-03
      92  -9.553366e-04 -8.367019e-04  1.870131e-04 -8.119666e-04  3.937504e-04
      93   6.915733e-04  9.643566e-04  2.011354e-03 -1.278398e-04 -7.960088e-04
      94  -1.457600e-03  2.324498e-04  5.443907e-04 -9.548827e-04 -1.034064e-03
      95  -6.966207e-05 -4.031667e-05  1.091155e-03  8.745142e-04  1.626206e-03
      96  -1.524158e-03 -9.216927e-04 -5.709203e-04  2.637202e-04 -1.274224e-03
      97   1.025278e-03 -6.101559e-04 -1.335568e-03  9.053878e-04  1.313393e-03
      98   2.470107e-04  1.069633e-03 -1.614451e-03 -1.911712e-04  9.525953e-04
      99  -1.071568e-04  1.084006e-03 -1.757490e-03 -6.555297e-05  8.805394e-04
      100  6.762506e-04 -1.089570e-03  1.315482e-03 -1.323620e-03  1.072569e-04
      101  1.949462e-05 -9.098175e-04  4.292214e-04 -1.186718e-03 -1.042822e-03
      102  3.831888e-04 -2.256974e-04  1.880114e-03  2.169894e-04  1.029913e-03
      103  9.525102e-04  9.044938e-05  5.582727e-04 -9.622877e-04 -6.305929e-05
      104 -8.220680e-04  8.097831e-04  5.308269e-04  1.009106e-03 -1.097562e-03
      105 -7.246372e-04  1.507609e-04 -9.465605e-04  8.288113e-04  1.824065e-03
      106  3.404227e-04  9.228997e-04 -2.017040e-03  5.836299e-04  2.579643e-04
      107 -5.454888e-04 -4.405410e-04 -2.044192e-03 -9.097925e-04 -9.600654e-04
      108 -1.582735e-03 -6.263606e-04 -1.791069e-03 -6.201590e-04 -1.987011e-03
      109 -1.198314e-03 -7.119630e-04 -1.405860e-03 -1.028483e-05 -9.240546e-04
      110 -1.465781e-03 -7.444463e-04 -2.269947e-04  7.538017e-04  1.332760e-04
      111  3.242608e-04 -3.269446e-04  1.565288e-03  2.217189e-04  6.218200e-05
      112  2.849978e-04 -1.144540e-04  7.166641e-05 -6.575847e-04  9.432735e-04
      113  1.482265e-03  3.840913e-05  1.347801e-04  6.209096e-04  1.969045e-03
      114  1.162362e-03  7.627665e-04  9.187016e-04  5.647573e-04 -8.544496e-04
      115  6.714169e-04  9.545746e-04 -2.371748e-04 -7.598613e-04 -1.630588e-03
      116  1.130328e-03 -2.524735e-04  1.072626e-03  5.501720e-04  1.223769e-03
      117  1.131255e-03  5.962380e-04  1.624492e-03  4.392383e-04  1.633300e-03
      118  7.041688e-04 -1.097936e-03  8.775537e-05 -8.427265e-04  1.416943e-03
      119 -5.246069e-04  6.851490e-04  1.303054e-03 -1.317633e-03  2.745833e-04
      120 -2.042498e-04  1.815535e-04  1.093353e-03  8.073627e-04  5.363489e-04
      121  8.947695e-04  7.226524e-04  1.703157e-03 -1.394478e-05 -1.464331e-03
      122  5.940119e-04 -3.271542e-05  1.597929e-03 -6.505629e-04  6.806204e-04
      123 -3.278928e-04  8.491050e-04  4.494903e-04  1.002483e-03  1.207900e-03
      124  2.573950e-04 -7.976375e-04  6.070791e-04 -1.242021e-03  1.627215e-04
      125 -1.253794e-03  3.236667e-04 -1.313726e-03 -5.852200e-04 -6.573234e-04
      126 -8.634480e-04 -1.926310e-04 -2.109968e-03  4.517227e-04  7.656584e-04
      127  2.998017e-04 -9.071623e-04 -1.666943e-03  4.419976e-05  8.933014e-04
      128 -8.956910e-04 -6.282762e-04 -1.402673e-03 -2.516949e-04 -6.146231e-04
      129  6.818925e-04 -1.674428e-05 -2.120810e-03 -6.599405e-04 -4.177752e-04
      130  1.255411e-03 -1.148203e-03 -6.720546e-04 -1.672970e-04  1.483225e-03
      131 -2.803023e-04  2.080376e-04 -1.306562e-03  5.796585e-04  1.444476e-03
      132  7.955455e-04 -5.981164e-04 -2.149003e-04  1.357834e-04  7.622847e-05
      133 -6.739192e-04  2.335012e-04 -4.300306e-04  7.515786e-06 -4.463132e-04
      134  1.477821e-03  8.936847e-04 -6.553355e-04 -3.915604e-04  1.361095e-03
      135  1.340875e-03  5.969500e-04 -9.768560e-04  1.261396e-03  1.169599e-03
      136 -4.114838e-04  2.321186e-04  7.419864e-05  8.514474e-04  8.151426e-05
      137 -1.227240e-03  6.841148e-05 -8.142091e-04 -7.847984e-04  1.434899e-03
      138  1.302496e-03 -7.357684e-04  7.068667e-04  6.194735e-04  9.916382e-04
      139  8.106314e-04  1.090865e-03  3.276721e-05  9.971543e-06  1.237140e-04
      140  1.100960e-03 -6.338522e-04 -7.686895e-04  1.758566e-04 -5.061692e-04
      141 -3.776448e-04 -4.502503e-04 -1.216216e-03  7.938027e-04 -1.267105e-03
      142 -5.268372e-04  7.446480e-04  5.993683e-04  9.369794e-04  1.181130e-03
      143  1.489552e-03  2.153697e-04 -2.393525e-04 -1.182849e-03  6.313880e-04
      144 -1.534361e-04  1.581091e-04 -7.780570e-04 -6.725789e-04 -4.755851e-04
      145  7.822058e-04 -8.231439e-04  3.667361e-04 -5.970558e-04  8.827942e-05
      146  1.416819e-03 -5.228344e-04  1.451639e-03  1.124222e-03  1.688772e-03
      147 -4.820216e-05 -1.077275e-03 -4.137007e-04  9.455753e-04  2.008258e-03
      148 -4.807842e-04 -3.211893e-04 -2.157880e-03 -7.392538e-04 -3.718492e-04
      149 -8.957673e-04 -6.531948e-04 -3.756337e-04  1.303986e-03  1.942816e-03
      150  1.487066e-03  3.271371e-04 -2.947370e-04 -1.322828e-03 -8.896718e-04
      151 -6.782032e-04 -5.262416e-04 -2.987280e-05 -4.759941e-04 -6.670118e-04
      152  1.226562e-03  4.734033e-05 -4.385648e-04  5.149077e-04 -1.756984e-04
      153 -8.814532e-05  9.219448e-04 -7.347816e-04 -5.006603e-04  1.773307e-04
      154  1.021129e-03 -6.921572e-05  1.430932e-03 -1.288371e-03  1.547918e-04
      155  1.581548e-03 -1.108809e-04  1.839114e-03 -4.363868e-04 -7.384029e-05
      156  4.843619e-04 -7.209763e-04  1.705041e-03  5.541224e-04  6.379853e-04
      157  1.040516e-03  5.569505e-04  6.855053e-04 -7.517398e-04  2.407054e-04
      158 -2.159619e-04 -1.020657e-03  7.118926e-04  9.989194e-04 -1.809488e-03
      159  2.730550e-04  8.984433e-04  4.889406e-04 -5.177833e-04 -2.977722e-04
      160 -8.349006e-04 -6.365677e-04  5.211217e-04 -1.351618e-03 -1.452272e-03
      161  6.218382e-05 -4.210993e-04 -1.686919e-03  7.210870e-04  9.376891e-04
      162  2.804912e-04  1.104580e-03 -1.388054e-03  8.737268e-04  2.336214e-04
      163  1.347274e-03  1.023396e-03 -7.123517e-04 -1.152193e-03 -5.845713e-04
      164  1.423754e-03 -5.397759e-04  1.188081e-03 -1.035585e-03 -1.222858e-03
      165  7.931478e-05  8.725206e-04  1.500274e-03  5.442767e-04  1.707631e-03
      166 -2.845424e-05  6.089044e-04  1.157132e-03  2.351191e-04 -1.565183e-03
      167 -7.336762e-04  1.108819e-03  8.430225e-04 -1.353815e-03  1.340549e-03
      168 -2.810359e-04  3.192965e-04  9.052096e-04  1.202616e-03 -1.767021e-03
      169  2.957898e-04 -1.151327e-03  1.254617e-03 -8.981430e-04 -7.433665e-04
      170  2.552620e-04  1.110641e-03  1.156691e-03 -9.344318e-04  1.960030e-03
      171  1.490717e-03 -6.293909e-04 -2.018830e-03 -3.321596e-04 -4.471067e-04
      172 -1.361545e-04  9.932683e-04  1.590352e-03  1.221122e-03 -6.451052e-04
      173 -1.528955e-03  9.325849e-04  8.682645e-04 -4.326629e-04  2.031375e-03
      174 -4.816259e-04 -5.945970e-04  1.653304e-03 -7.152235e-04  1.810885e-03
      175  1.205476e-03  2.964807e-04 -1.398743e-03  4.753621e-05 -4.135566e-04
      176 -4.754965e-04  3.110857e-04  1.377259e-03 -3.316671e-04  4.691473e-04
      177  1.276133e-03 -5.728269e-04  6.787633e-04  1.275287e-03 -1.866056e-03
      178 -1.379169e-03  8.468660e-04  1.589170e-04 -7.192586e-04  1.490586e-03
      179  1.170072e-03  6.969627e-04  4.815654e-04 -6.085455e-04  1.376768e-03
      180 -7.110866e-04  1.071857e-03  6.736424e-04 -4.115482e-04 -1.309720e-04
      181  3.757002e-04 -7.734583e-04 -1.591728e-03  1.322638e-03 -1.677749e-03
      182 -5.945880e-04  2.583811e-04  2.035964e-03  6.976956e-04  6.693620e-04
      183  9.109743e-04 -5.272275e-04 -1.805494e-03 -8.187997e-04  2.046885e-04
      184 -8.850093e-04 -2.495079e-04  1.533030e-03 -7.722160e-04 -1.972536e-03
      185 -1.289950e-04  1.516806e-05 -1.574133e-04  7.006674e-04  4.618608e-04
      186  1.314506e-03  3.573103e-04 -8.201445e-04 -4.935163e-06 -1.571367e-03
      187 -7.543466e-04  4.301424e-04 -1.844918e-03 -1.029588e-03  1.687574e-03
      188  2.365078e-04  1.083293e-03 -2.078691e-03 -8.679756e-04 -1.747909e-03
      189  9.165204e-04  1.129077e-03  1.074544e-03  7.647474e-05 -7.456780e-04
      190 -7.783938e-04 -2.139838e-04  1.039792e-03  5.032532e-04  1.119635e-03
      191 -1.009705e-04 -2.423453e-04  9.529384e-04  1.126400e-03  3.519438e-04
      192 -4.985741e-04 -1.078394e-03 -1.780179e-03 -4.800138e-04 -6.200507e-04
      193 -1.466464e-03 -7.815442e-05 -8.998289e-04 -1.290818e-03 -4.724338e-04
      194 -1.432323e-03 -3.358748e-04 -1.930609e-03 -5.113179e-04 -1.555290e-03
      195  7.041539e-04  5.609485e-04  7.463780e-04  1.220997e-04  1.296484e-03
      196 -1.424232e-03 -9.814730e-04 -8.096644e-04  4.096225e-04  3.517175e-04
      197  8.397619e-04  5.678530e-05 -1.094480e-03 -1.008422e-03 -1.154819e-03
      198 -1.018299e-03  6.382768e-04 -7.866656e-04  4.186380e-04  1.400908e-03
      199  6.237731e-04 -6.985415e-04  1.518424e-03  1.159970e-03  1.678976e-03
      200 -1.194458e-03 -6.610477e-04 -1.065098e-04 -1.185162e-03  8.557432e-04
      201 -1.303554e-03  1.079544e-03 -1.492782e-03  1.023219e-03  2.931322e-04
      202  3.763839e-04 -5.832109e-04 -1.746081e-03 -1.236137e-03  3.611962e-04
      203 -9.654186e-04  4.982444e-04 -4.619913e-04 -5.792949e-04  1.579091e-03
      204  4.922793e-04  1.220853e-04 -7.856485e-04 -1.225924e-03 -1.174198e-03
      205  1.071381e-03 -5.317705e-05 -1.220795e-03 -8.921358e-04 -1.069513e-03
      206  6.505469e-04 -1.091505e-03  1.294309e-03 -2.365622e-04  9.282227e-04
      207  1.088441e-05  7.522898e-04  1.047600e-03  1.178085e-03 -6.599785e-05
      208 -1.115853e-03 -4.171458e-04 -8.471196e-04 -1.350977e-03 -1.167407e-03
      209  1.317992e-03 -8.986400e-04 -2.965544e-04  1.036933e-03  2.701162e-04
      210  8.672811e-04  4.793364e-04  1.947933e-03 -5.400515e-04  4.581718e-04
      211  7.791480e-04  3.136556e-04  6.859838e-04  1.052064e-03 -2.023160e-06
      212 -8.608003e-04  9.520605e-04 -5.333268e-04 -4.009853e-04  3.317472e-05
      213  8.335450e-04 -1.043282e-03 -8.385043e-04 -8.364056e-04  1.068099e-03
      214 -2.996548e-04 -4.223023e-04 -1.335932e-03 -1.727653e-04  1.752970e-03
      215 -1.854204e-04  3.718902e-04 -2.027399e-03  9.710952e-04 -2.035861e-04
      216 -6.546208e-04 -4.314263e-04 -5.701640e-04  1.280171e-03  3.313100e-04
      217 -1.405480e-03 -7.981299e-04  1.297358e-03 -1.044030e-03  2.834224e-04
      218  7.045525e-04  2.099031e-04  8.936543e-04 -9.133130e-04  1.822403e-03
      219 -9.249342e-05  6.700530e-04 -1.067776e-03  2.387722e-04  1.438859e-03
      220  3.490665e-04  1.036042e-03 -4.906724e-04 -1.278771e-03 -9.087869e-04
      221  8.845426e-04  8.076790e-04  1.033829e-03 -1.283714e-03  6.759967e-04
      222  3.286802e-04 -1.098713e-04  2.076078e-03 -6.990121e-04 -1.386311e-03
      223 -1.163294e-04  9.995234e-04  2.081503e-03 -7.522831e-04  8.684311e-04
      224  1.049022e-04  8.607390e-04 -1.238617e-03  7.381974e-04 -1.962159e-03
      225  7.540024e-04 -8.807791e-04 -1.142722e-03 -8.163711e-04 -2.853156e-04
      226  2.421166e-04 -2.121894e-04  2.032895e-03  6.559824e-04  4.540553e-04
      227 -1.590238e-04  1.129324e-04 -1.904134e-03  9.271685e-04 -1.573943e-03
      228 -1.607349e-03  4.882652e-04  2.727198e-04  1.299764e-03 -1.447921e-03
      229  1.572243e-03 -1.211539e-04 -4.501898e-04  8.817277e-04  1.548087e-03
      230 -4.559542e-04 -1.582232e-04  2.038209e-03  1.307038e-03 -5.954697e-04
      231  2.211900e-05 -5.541520e-05 -1.049310e-03  4.264479e-04 -1.848955e-03
      232 -1.236566e-03  3.461398e-04  1.300385e-03 -2.205801e-04  4.530042e-04
      233 -1.422945e-05  9.376219e-04 -2.126378e-03  4.903701e-04 -6.306858e-04
      234  1.083256e-03  6.653185e-04 -1.372981e-03  8.050409e-04  1.299316e-03
      235 -9.082121e-04 -7.377466e-04  1.173911e-03 -1.134151e-03 -1.453603e-03
      236  3.319172e-04 -1.057705e-04  1.425038e-03 -5.024731e-04  1.079852e-03
      237 -5.153931e-04 -9.717034e-04 -2.015846e-03  8.507757e-04  2.466478e-04
      238 -1.163462e-03  1.909591e-04 -3.794546e-04  7.029502e-04  5.802789e-04
      239 -1.299605e-03  4.451339e-04  4.186932e-04 -4.245694e-04  1.387974e-03
      240 -1.432165e-03  3.462680e-04  9.719407e-04 -1.057399e-03 -2.993025e-04
      241 -7.541081e-04  2.966008e-04  1.241132e-03  5.289072e-04 -5.838798e-05
      242 -7.532438e-05 -9.615401e-04  1.705292e-03 -8.405090e-04  1.297920e-03
      243  1.612132e-03  2.580862e-04  1.600571e-03  1.095877e-03  1.218973e-03
      244 -9.557019e-05 -8.759907e-04  6.233447e-04 -7.050489e-05  5.026725e-04
      245  1.386959e-03 -4.210521e-04  1.130573e-03 -1.273387e-03  1.259317e-03
      246 -9.349415e-04 -5.672825e-04 -9.019095e-04 -1.131626e-03  9.418487e-04
      247 -4.417224e-04  3.528250e-04 -7.456987e-04 -7.687164e-04 -3.616737e-05
      248  7.126230e-04  4.476205e-04  6.261544e-05 -7.911030e-04  1.372008e-04
      249  1.207172e-03 -9.109758e-04  1.560365e-03  4.048878e-05  8.748707e-04
      250 -1.363272e-03  3.130818e-04 -1.080333e-03 -4.823680e-04  1.817434e-03
      251 -4.861951e-04  8.333854e-05  2.494826e-04  6.690241e-04  1.205610e-03
      252 -1.292024e-03  7.515340e-04  8.120845e-04 -9.499904e-04  1.418803e-03
      253 -5.685949e-04 -6.088883e-04 -1.454095e-03 -4.285852e-04  2.292029e-04
      254  3.996872e-05  3.211473e-04 -2.034738e-05  3.495804e-04 -3.944585e-04
      255  4.565552e-04 -2.516794e-04 -5.157469e-04 -5.226191e-04 -2.331123e-04
      256 -7.966188e-04  4.853155e-05 -2.116225e-03  9.024464e-04  8.740276e-04
      257  1.485723e-03 -7.500517e-04 -1.051032e-03 -1.252824e-03  1.681578e-05
      258  9.547780e-04  6.199835e-04  1.652749e-03 -5.837918e-04  1.010511e-03
      259  7.182485e-04  5.992753e-05  1.088124e-03 -2.126895e-04 -7.640410e-04
      260  5.838109e-04  7.515804e-04 -1.497571e-03 -5.265548e-04 -4.737411e-04
      261 -1.428558e-03  6.348688e-05  1.215035e-03  5.356939e-04  1.435206e-03
      262 -2.341243e-04  7.490142e-04 -1.478184e-03 -4.006616e-04 -4.700714e-04
      263 -1.092859e-03 -4.550178e-04  1.318705e-03  6.284029e-05 -4.495245e-04
      264  1.413892e-03  4.586180e-04 -5.486681e-04  1.253564e-03 -7.389968e-05
      265 -5.667556e-04 -9.502220e-04 -1.320399e-03  9.482945e-04  1.890681e-03
      266 -1.448111e-03 -1.135185e-03 -1.067555e-03  1.297066e-03 -1.391503e-03
      267 -9.016738e-04  7.863188e-04 -1.191818e-03  7.336810e-04 -1.575685e-03
      268 -6.400477e-04 -6.332154e-04 -6.243786e-04  7.605146e-04 -1.536791e-04
      269  8.931794e-04  2.677099e-04  1.678748e-03  1.305847e-04 -1.113668e-03
      270 -1.441286e-03  1.662501e-04 -2.021582e-03 -1.239030e-03  1.313032e-03
      271  1.347895e-03 -1.036827e-03 -2.136157e-03  1.230511e-03 -2.400266e-04
      272 -2.019068e-04  5.396605e-04  6.139110e-04 -3.875151e-04 -5.835536e-04
      273 -5.133490e-04  4.702653e-04 -8.271824e-04 -3.343344e-04 -6.498597e-04
      274 -3.969244e-04  1.025031e-03  1.505164e-03 -9.811708e-04  4.362675e-04
      275  7.434799e-04 -1.064415e-03  1.989676e-03 -6.513660e-05 -1.008698e-03
      276  1.011307e-03  9.422631e-04  3.953278e-04  1.147184e-03  1.279844e-03
      277 -1.586975e-03  5.713419e-04 -6.896512e-04  3.566026e-04  1.535811e-03
      278 -9.548343e-04  8.075384e-04  1.986943e-03 -1.509508e-04  3.010302e-04
      279 -6.655714e-04  1.416697e-04  6.939521e-04 -1.256168e-03 -8.801763e-04
      280 -1.583358e-03  1.414376e-04 -1.845380e-03 -7.688507e-04  2.715377e-04
      281  7.737984e-04  5.477554e-04  1.073834e-03  8.948699e-05  9.674920e-04
      282 -7.668591e-04  1.421428e-04 -7.103837e-04  2.508053e-04  1.923167e-04
      283 -2.773961e-04 -5.423801e-04  1.831469e-03  9.886232e-04 -4.056103e-04
      284  1.000738e-03 -7.945398e-04 -1.216362e-04  1.317372e-03 -6.167835e-04
      285 -1.119228e-05 -7.581773e-04 -8.245175e-04 -8.917448e-05  1.123701e-03
      286  1.364121e-03 -7.559062e-04  2.098262e-03 -4.856517e-04  7.979743e-04
      287 -1.397815e-03  4.509603e-04 -9.142375e-04  2.663139e-04 -1.103003e-03
      288  9.151460e-04 -1.005340e-03  1.404895e-03 -7.789843e-04 -8.407212e-04
      289  1.531516e-03 -2.851527e-04 -2.009580e-04 -3.683931e-05  1.705445e-04
      290 -4.601951e-04  1.794802e-04  7.401654e-04 -8.169996e-04 -1.214854e-03
      291 -1.441493e-03  8.414916e-04  4.214598e-04  8.669628e-04  1.198240e-03
      292 -6.925506e-04  1.042219e-03  1.535333e-03  9.322455e-04  8.004636e-04
      293 -1.499783e-03 -2.304549e-05 -1.690589e-03 -6.568955e-04 -6.859396e-04
      294  1.026053e-03  1.766705e-04 -1.427724e-03 -4.595897e-04 -7.306639e-04
      295  1.483350e-03 -8.001176e-04  1.418200e-03 -3.238776e-04  1.354839e-03
      296 -9.033828e-04  8.545245e-04 -1.543149e-03  5.070264e-04  1.200927e-03
      297 -4.995292e-04 -1.044584e-03 -1.901875e-03 -2.169489e-04  2.546448e-04
      298 -1.439997e-03 -3.344791e-05 -1.615746e-03  7.675818e-04  8.927170e-04
      299 -1.335628e-03  8.049854e-04 -2.184297e-03 -3.531865e-04 -4.120122e-04
      300  1.415309e-03 -8.875599e-04 -2.066874e-03 -7.235968e-04 -1.058756e-03
      301 -9.538007e-05  2.658695e-04  1.989634e-03 -3.103470e-05 -1.935664e-03
      302 -5.807258e-04  1.537576e-04 -1.065649e-04 -6.427126e-04 -1.552854e-03
      303 -6.775719e-04  1.626161e-04  7.525116e-04 -5.096548e-04  1.524260e-03
      304 -3.714602e-04 -5.489244e-04  5.731064e-04  7.086928e-04  1.308811e-03
      305 -1.505960e-03 -7.914017e-04  1.579764e-03  1.024009e-03 -1.640554e-03
      306 -1.169127e-03  2.939926e-04 -5.049895e-04 -7.452431e-04  1.369679e-04
      307  2.691573e-04 -7.428626e-04 -6.103045e-04 -3.727409e-04  1.060157e-03
      308 -1.626486e-04 -5.354794e-04  1.124211e-03 -1.003674e-03 -6.716172e-04
      309 -7.821712e-04 -3.324033e-04  6.436756e-04 -8.324506e-04  1.846748e-03
      310 -4.747465e-05 -1.588546e-04 -1.239870e-03  2.124666e-04  4.269757e-04
      311 -6.348872e-04 -6.196494e-04 -1.716800e-03 -1.202934e-03 -1.213942e-03
      312 -8.380477e-04 -1.138170e-03  6.274241e-04  3.464720e-04 -4.659374e-04
      313 -1.359203e-03  1.373537e-05  2.951257e-04  5.031979e-05 -1.451692e-03
      314 -1.393327e-04  5.491271e-05 -1.817743e-03 -8.386484e-04 -1.966166e-03
      315 -1.056744e-03  6.816273e-04  1.974120e-03  7.324650e-04 -1.538108e-03
      316  5.613021e-05 -8.682226e-04 -5.995628e-05  5.209042e-04 -3.906368e-04
      317  1.402133e-03  4.879854e-04  5.477013e-04  5.965617e-04  1.641464e-03
      318  1.361189e-03 -2.446369e-04 -1.980502e-03  2.528059e-04 -3.292620e-04
      319 -3.790610e-04 -5.602297e-04 -9.444514e-05  8.985570e-04  2.972662e-04
      320 -7.989921e-04  4.196007e-04  4.873921e-04  1.216396e-03 -8.844837e-04
      321 -4.471286e-04  1.573218e-04  4.190274e-04  1.190766e-03 -4.475179e-04
      322  7.998430e-04  1.107275e-03  1.473490e-03 -1.013427e-03  7.163453e-04
      323  5.486871e-04  1.041278e-03 -7.972490e-04 -4.903596e-04  1.027216e-04
      324  1.606717e-03  9.194633e-04 -2.125772e-03 -4.639701e-05 -9.536615e-04
      325 -9.043630e-05  5.293345e-04  1.394382e-03 -5.083655e-04 -9.729210e-04
      326 -8.335474e-04 -8.351553e-04 -7.920091e-04 -1.253617e-03 -4.074020e-04
      327 -3.550130e-05 -8.673367e-04  6.705700e-04 -8.111692e-04  5.373676e-04
      328 -7.241559e-04 -2.306127e-04 -1.929987e-03  5.820560e-04 -3.695702e-04
      329  4.090145e-04 -5.217733e-04 -1.963791e-03  1.068363e-03 -1.504536e-03
      330 -1.056683e-03 -8.945271e-04  4.134890e-04  3.548376e-04 -1.191824e-03
      331  9.532273e-04 -9.534881e-05  1.847334e-03 -1.173014e-03  1.411267e-03
      332 -1.462515e-03 -1.109771e-03  8.773347e-05 -6.994055e-04 -2.482595e-04
      333  1.175174e-03 -8.494595e-04 -5.572322e-04  3.205263e-04 -1.367157e-03
      334  7.141459e-04  9.086769e-04  4.615905e-04 -1.210964e-04 -1.621240e-03
      335  5.472317e-04  6.955440e-04 -1.541918e-03 -3.219235e-04  1.322681e-03
      336 -1.034154e-04  8.599199e-06  2.116842e-03 -3.785396e-04  8.741585e-04
      337 -1.092300e-04 -4.645583e-04 -7.559691e-04 -5.257524e-04 -7.310229e-04
      338 -1.324169e-03  7.101845e-04 -8.729442e-04  6.840343e-04 -8.527224e-05
      339  1.605500e-03  6.295709e-04 -1.739518e-03 -3.279546e-04 -5.743170e-04
      340 -9.485038e-04  2.852678e-04 -1.563807e-03  1.026516e-03  7.873639e-04
      341 -1.609399e-03  3.576064e-04 -9.038545e-04 -4.493674e-04 -1.606774e-03
      342  5.072331e-04  1.124009e-03  7.957448e-04  9.357522e-04  1.385740e-04
      343 -1.238360e-03 -4.798037e-04  1.607310e-03  2.209395e-04 -1.077222e-03
      344 -9.988665e-04 -7.080411e-04  6.018267e-04 -1.311474e-03 -1.912141e-03
      345 -9.989951e-04  7.832561e-04  1.882169e-03  1.346625e-04 -4.638054e-05
      346 -1.471028e-04 -3.296069e-06 -9.745648e-04  9.417213e-04 -6.691410e-04
      347 -6.095394e-05  1.116398e-03  7.156494e-04 -7.481509e-04 -7.981886e-04
      348 -1.457982e-03  1.000043e-03 -2.086741e-03  1.139740e-03  6.738642e-04
      349 -1.130264e-03 -8.657397e-04 -1.069976e-03 -1.013179e-04 -1.409287e-03
      350  1.186429e-03 -6.446867e-04 -1.686181e-03  6.312085e-04 -1.352945e-03
      351 -1.348817e-03  3.603096e-04 -4.944995e-05  9.218523e-04  1.212068e-03
      352 -9.807394e-04 -1.173731e-04 -4.677011e-04  4.462682e-05  1.139972e-03
      353 -5.058889e-04 -5.030982e-04  1.718249e-03 -8.315688e-04  1.424580e-03
      354 -9.578487e-04 -1.577193e-05 -1.220462e-03 -1.265841e-03  4.607012e-04
      355 -9.233547e-04  4.703848e-04 -3.930119e-04 -9.294535e-05 -1.933313e-03
      356  5.335396e-04 -5.245043e-04 -1.627045e-03  6.211207e-04 -3.951176e-04
      357 -1.262934e-03 -6.735394e-04 -5.185244e-04  9.923816e-04  1.562663e-03
      358 -2.023678e-04 -1.613253e-04 -5.651826e-04 -4.601824e-04 -1.867568e-03
      359 -9.082936e-04  6.268913e-04  2.128518e-03 -1.956255e-04 -1.060696e-03
      360 -6.923108e-04 -4.413365e-04 -3.660339e-05  6.610514e-04  7.645315e-04
      361 -2.713823e-04  3.993602e-04  2.933876e-04  5.080600e-04  4.472571e-04
      362 -4.010093e-04 -6.634172e-04 -1.290179e-03 -7.857987e-04 -3.650930e-04
      363  1.402096e-03  6.846599e-04  7.186507e-04  9.221507e-04  1.737719e-03
      364 -7.896792e-04 -4.251598e-04 -2.181506e-03  3.742836e-04  1.102723e-03
      365 -4.614664e-05 -3.866562e-05 -1.900941e-04  5.360951e-04  1.716032e-03
      366 -3.871046e-04 -9.043437e-04 -4.543816e-04 -5.855622e-04 -8.440249e-04
      367 -1.050198e-04 -4.932674e-04  1.483183e-03  1.098665e-04 -3.010143e-04
      368  2.847581e-04  9.018854e-04 -3.035820e-04  9.418210e-04  1.178802e-03
      369  5.947696e-04  1.017044e-03 -9.185503e-04  1.170681e-03 -3.921634e-04
      370  1.392974e-03  5.237676e-04  1.059309e-03  9.013128e-04  1.229533e-03
      371  5.289861e-04  7.975370e-04 -2.159861e-03  7.437480e-04  6.504832e-04
      372  1.415708e-03  7.957380e-04 -2.146333e-03  3.512488e-05  1.288265e-03
      373  8.224077e-04 -6.057494e-04 -1.459212e-03  1.003706e-03 -1.557912e-03
      374  3.433568e-04 -6.141816e-04 -3.830815e-04 -8.586347e-04  1.846871e-03
      375 -1.507784e-03 -1.108896e-03  1.921910e-03 -1.268696e-03  1.616577e-03
      376 -3.550363e-04  1.073776e-03  1.108400e-03  1.124193e-03 -9.751974e-04
      377  9.509190e-04  8.114466e-04  1.714521e-03 -1.275876e-03  1.302440e-03
      378 -1.577828e-03 -2.370375e-04 -1.131420e-03 -5.566172e-04  1.253493e-03
      379 -1.356712e-03  4.152901e-04 -2.113900e-03 -6.702935e-04 -7.324715e-04
      380  1.220072e-03  6.313762e-04  1.246039e-03  3.825469e-04 -1.955159e-03
      381 -7.215597e-05  7.576759e-04 -2.044519e-03 -9.844734e-04  3.291508e-04
      382 -1.305242e-04  1.378644e-04 -2.186900e-03 -9.809017e-04  1.198081e-04
      383  1.253582e-03  5.047922e-04  5.891118e-04 -1.291897e-03 -1.753220e-03
      384  4.036206e-04  7.515144e-04  1.296057e-03  6.470488e-04 -9.970901e-05
      385  3.486880e-05 -4.406858e-04 -1.877895e-03 -4.505061e-04  1.380127e-03
      386  5.780299e-04 -4.013018e-04 -1.122933e-03 -5.168578e-04 -3.349673e-04
      387 -2.896521e-04  4.677896e-04  6.335288e-04  1.269420e-03 -1.705997e-03
      388 -5.798439e-04  3.100356e-04 -6.685122e-04  1.448348e-04  1.227476e-03
      389 -8.747689e-04 -4.918732e-04  1.272883e-03  4.754502e-04 -4.807822e-05
      390  6.971586e-04 -8.808205e-04 -5.373479e-04 -4.847271e-04 -5.908781e-04
      391  7.533937e-04  7.269997e-04  4.664548e-04 -2.605772e-04  1.087261e-05
      392 -6.184123e-04  3.919354e-04  6.917431e-04 -7.772158e-04 -1.097333e-03
      393 -8.563583e-04  7.622234e-04 -1.176338e-03  1.082604e-03 -1.993368e-03
      394  2.403183e-05 -2.749066e-04  1.692475e-03 -5.822827e-04 -1.393379e-03
      395  1.329838e-03  6.806575e-04  1.572249e-03  1.048738e-04 -1.150330e-03
      396 -4.668025e-04 -3.291423e-04  1.070678e-03 -3.979257e-04  1.331175e-03
      397 -1.130479e-03  4.730075e-04 -1.084658e-03  1.091160e-03  6.158572e-04
      398  6.516348e-04  7.006082e-04  8.973345e-04  2.168654e-04 -1.722700e-03
      399 -6.872839e-04 -6.317439e-04  6.468650e-06 -1.054175e-03  2.717043e-04
      400 -2.380199e-04  4.852739e-04 -4.335498e-05 -1.301284e-03  9.247205e-04
      401 -6.749262e-05 -3.920525e-04 -8.820232e-04 -8.564054e-04  2.103051e-04
      402  3.537286e-04  2.488482e-04  1.288691e-03 -6.115260e-04 -1.841043e-03
      403 -2.989678e-04  2.263539e-04  2.005723e-03  2.004362e-04  3.631605e-04
      404 -5.213020e-04  2.538242e-05  1.036332e-03  4.167678e-04 -8.197296e-04
      405  1.085547e-03 -2.717754e-04  7.133276e-04 -1.331130e-03 -1.177833e-03
      406  1.237818e-03 -2.485877e-04 -1.162618e-03 -3.421380e-04 -9.041655e-04
      407 -1.302900e-03  1.069643e-03 -7.796860e-04 -8.523985e-04  1.988383e-03
      408  2.081261e-04 -3.180622e-04 -2.198285e-04  8.701899e-04 -1.347407e-03
      409  4.382549e-04  1.296857e-04  1.615557e-03  2.548387e-04  1.679129e-03
      410  1.636143e-04 -9.376400e-04 -3.153543e-04 -7.002616e-05  3.039628e-04
      411 -1.152075e-03  9.636140e-04 -4.767463e-04  2.909653e-04  2.046105e-03
      412 -2.144377e-05 -6.521103e-04 -1.573015e-03 -6.355540e-04  7.422384e-04
      413 -5.195085e-04 -1.042573e-03  1.472770e-03 -7.094684e-04  1.287543e-03
      414 -1.535127e-03 -3.874026e-04  1.612778e-04  2.902286e-04  1.204097e-03
      415  6.231436e-04 -2.623452e-04 -6.550422e-04 -5.210187e-04  1.218744e-03
      416  1.412745e-03 -9.966532e-05 -5.294927e-04  1.153032e-03  5.466642e-04
      417  5.751431e-04 -9.387595e-04  1.132599e-03 -7.377539e-04  6.777253e-04
      418 -4.052041e-04 -1.907548e-04 -2.705949e-04 -1.272108e-03  1.283715e-03
      419 -9.064013e-04  4.618330e-04  1.163708e-03  7.455392e-04 -1.042868e-04
      420  8.099683e-04  5.161593e-04 -2.418213e-04  6.842749e-04 -1.637276e-04
      421 -1.041963e-03  2.428837e-04  3.792881e-04  5.980101e-04  1.076760e-03
      422 -2.619897e-04 -9.361397e-04  1.615305e-03  1.775463e-04  1.149890e-03
      423 -4.020233e-05 -1.259753e-04  1.164695e-04 -2.222712e-04  1.138914e-03
      424 -7.017801e-05  1.355607e-04 -1.568960e-03 -3.134243e-04  5.340267e-04
      425 -1.431435e-03 -9.557670e-04  6.698253e-04 -8.232358e-05  1.964768e-03
      426 -3.825321e-04 -8.258627e-04 -3.303027e-04 -2.074239e-04 -1.951341e-03
      427 -4.764988e-04  1.162407e-04  2.019821e-03  9.946796e-04  1.613135e-03
      428 -7.784704e-04 -4.120479e-04  1.142627e-03  5.913925e-04 -8.548476e-04
      429 -1.519649e-03 -4.119300e-04 -9.617853e-04  7.240741e-04 -9.177861e-04
      430  8.961060e-04 -2.248736e-04  2.080992e-03 -1.226834e-04  2.016655e-04
      431  1.457325e-03  1.129428e-03  1.031768e-03 -1.213115e-03  9.638274e-04
      432 -8.185705e-04 -1.175001e-03 -2.054584e-03  1.313083e-03 -9.834888e-04
      433  1.412810e-04 -7.434873e-04 -6.719093e-04 -6.424586e-04  1.573059e-04
      434  1.078839e-04 -9.204404e-04 -9.859635e-04  8.927834e-04 -9.073912e-04
      435  7.864802e-05  1.783110e-04 -1.133589e-03  9.481137e-04  6.756202e-04
      436  1.383789e-03  2.298016e-04  1.774335e-03  2.241401e-04 -1.713648e-03
      437 -4.157625e-04 -2.200097e-04 -3.282539e-04 -1.297813e-03 -1.089751e-03
      438  9.252605e-04  1.132740e-03 -4.925836e-04 -4.226723e-04  9.349564e-04
      439 -2.701970e-04 -6.458056e-04  9.916132e-04 -1.607826e-04  2.055006e-03
      440  1.016863e-03 -2.228147e-04 -1.682934e-03 -8.324778e-04  1.437903e-03
      441 -3.962632e-04  3.907257e-04 -3.771546e-04  1.171792e-03  1.625422e-05
      442  9.988621e-04 -7.525413e-04 -1.831237e-03 -8.497504e-04 -7.256489e-04
      443 -9.123950e-04  7.953275e-04 -7.717440e-04  9.177842e-04 -1.614774e-03
      444  4.896420e-04  8.726215e-05 -1.246980e-04 -4.378855e-04 -8.631905e-04
      445 -1.373417e-03 -1.141036e-03  9.850162e-04  9.316121e-04 -2.882037e-04
      446  7.992676e-04  7.444029e-04  3.851975e-04  6.393928e-04 -1.711592e-03
      447 -2.257553e-04 -6.452612e-04 -2.985365e-04 -1.266283e-03  8.007439e-05
      448 -1.432917e-03 -7.164354e-04  2.647965e-04 -7.775750e-04  7.859473e-04
      449  5.215369e-05 -8.847347e-04  1.583365e-03 -9.496490e-05 -1.970115e-03
      450 -1.219443e-04  4.053770e-04  9.803041e-04 -1.307514e-03 -1.132276e-03
      451  3.057321e-04  1.042963e-04 -4.027039e-05 -1.351002e-03 -1.260710e-03
      452 -1.468054e-03 -1.158549e-03 -6.969473e-04 -3.283132e-04 -1.004788e-03
      453  1.591222e-03 -9.370824e-04 -8.612137e-04 -8.939674e-04 -1.797097e-03
      454 -5.945044e-04 -1.019963e-03 -1.871285e-03 -1.346305e-03  5.614361e-04
      455  1.051154e-03  6.634717e-04  1.658246e-03  8.393552e-04  2.477275e-04
      456  9.828156e-04  1.124194e-03 -2.930729e-04 -8.202840e-04 -9.098887e-04
      457  2.187380e-04  4.159440e-04 -1.482242e-04  4.814454e-04 -3.733812e-04
      458  1.013156e-03  6.620553e-04  1.228514e-03 -5.050852e-04  1.828294e-03
      459 -1.579181e-03  8.576813e-04  1.778328e-03 -5.813245e-04 -6.456558e-04
      460 -2.401330e-04 -1.012388e-03 -3.201983e-04  1.362860e-04  7.529257e-04
      461  1.310056e-03  4.126106e-04  1.480279e-03  1.764201e-04  3.668864e-04
      462 -8.591134e-04 -5.054312e-05  4.695574e-04 -9.881735e-04 -1.564997e-03
      463 -1.352020e-03 -2.465765e-04  1.580603e-03  6.841992e-04  1.764223e-03
      464 -1.552863e-04 -7.263413e-04  4.153755e-05 -8.925608e-04 -1.226621e-03
      465  7.128569e-04 -1.107947e-03 -1.262654e-03  4.354395e-04 -1.016972e-03
      466  1.025312e-03  2.300677e-04 -9.241315e-05  6.607733e-05  3.081248e-04
      467 -8.926448e-04  2.883256e-04 -1.471678e-03  1.056155e-03  5.156373e-04
      468  1.144575e-03  8.840397e-04  2.070874e-03  1.429786e-04  1.441005e-04
      469  1.267254e-03  1.004875e-03  1.380824e-04 -5.398151e-04  2.047815e-03
      470 -1.315161e-03 -5.992454e-04  1.466066e-03 -2.233658e-04  1.318469e-03
      471 -8.146988e-04  8.262038e-05  1.780223e-03 -2.545218e-04 -4.086921e-04
      472  9.071083e-04  4.322260e-04 -1.772536e-03  1.504213e-04 -1.553108e-03
      473 -5.720986e-04  2.746629e-04 -7.174156e-04  1.062445e-03 -1.384499e-03
      474  1.550931e-03  6.141528e-04  6.207839e-04  6.788287e-04 -1.256695e-03
      475 -5.587571e-04  9.996537e-04 -1.822415e-03 -3.475074e-04 -1.400124e-03
      476  6.185475e-04  2.535889e-04 -5.656897e-04  1.005671e-03  1.622779e-03
      477 -1.497400e-03 -9.037274e-04 -8.155373e-04  7.069408e-04  7.591646e-04
      478  5.394699e-04 -5.695474e-04  1.694549e-03  6.540943e-04  1.017826e-03
      479 -2.030370e-04 -4.269330e-04  8.834862e-05  1.120631e-03 -8.601260e-04
      480 -4.505612e-05  6.316947e-04  8.663741e-05 -8.418799e-04 -1.615711e-03
      481  3.307306e-04 -4.686260e-04 -1.819517e-03  1.844606e-04  1.870233e-03
      482 -1.352896e-03 -7.568375e-04 -2.193246e-03 -1.039463e-03 -4.567951e-04
      483 -4.332577e-04  4.961585e-04 -9.668906e-04  7.375026e-04 -1.259871e-03
      484  7.506261e-04  8.885537e-04 -1.394954e-03 -7.597937e-04 -7.870010e-04
      485  6.532359e-04 -7.901876e-04  1.265441e-03  1.315401e-03 -1.358181e-03
      486  6.287300e-04 -2.206537e-04  7.023130e-04 -1.936730e-04  3.882376e-04
      487 -1.271721e-03  1.125753e-03 -1.313110e-04 -2.357142e-04 -1.689972e-03
      488  1.006209e-04  1.751240e-04  7.142169e-05 -8.902476e-04 -1.650879e-03
      489  1.141797e-04 -9.782841e-04  2.085174e-03 -2.197677e-05  6.034324e-04
      490  3.617459e-04  3.828825e-04 -1.990083e-03  1.204943e-03  1.651241e-04
      491 -5.791252e-04 -5.430673e-04 -8.065713e-04 -8.738522e-04  1.002931e-03
      492 -1.136994e-03  6.082387e-04 -1.961149e-03 -9.152806e-04 -3.182771e-04
      493  1.065985e-03  3.450930e-04 -1.323224e-03  7.113075e-04 -1.738840e-04
      494 -4.384387e-04 -1.073674e-03 -1.822746e-03 -4.905612e-04 -1.393147e-03
      495  1.343523e-03  5.935138e-04 -2.103852e-03 -1.330644e-03 -1.426292e-03
      496  9.875890e-04 -2.691954e-04 -6.859237e-04  8.522081e-04  8.560171e-04
      497 -6.975027e-04  1.111354e-03 -1.090980e-03 -2.274306e-04 -6.310939e-04
      498 -3.318678e-04  1.276802e-04  1.834119e-03  2.328203e-04  1.252294e-04
      499 -6.219199e-05  8.283866e-04 -1.155556e-03  4.955097e-04 -1.248840e-03
      500  1.764935e-04 -7.326907e-04  2.089259e-03  1.712393e-04  1.396853e-03
      501 -2.704119e-04 -1.062743e-03 -1.748925e-03 -1.349977e-03  2.193802e-04
      502 -1.291677e-03 -9.497719e-04 -1.538814e-03 -1.817091e-04 -1.439321e-03
      503  2.484224e-04 -2.384758e-04 -1.644026e-03  9.160237e-04 -1.007015e-04
      504  1.566527e-03  4.493017e-04 -1.501798e-03 -6.591395e-04  5.747915e-04
      505 -7.712703e-04  1.129380e-03  1.425006e-03 -2.928381e-04 -5.754628e-04
      506 -9.976911e-04 -4.937378e-04  1.407870e-03 -1.016267e-03 -3.566654e-04
      507  3.040420e-04 -6.571697e-04 -7.518570e-04 -3.438009e-04  1.944471e-03
      508  9.352845e-04  7.850408e-04 -1.665419e-03  8.662663e-04 -1.535499e-04
      509  1.001340e-03  6.540781e-04  3.736097e-04  3.996776e-04 -4.346960e-04
      510 -6.665727e-04  5.907051e-04  1.813508e-03 -3.422256e-04  2.070161e-04
      511  3.946607e-04 -9.527474e-05 -8.283434e-04  1.085436e-03  1.940170e-03
      512 -1.279597e-03 -1.751972e-04 -1.924823e-03  1.092900e-03  1.619981e-03
      513  1.576368e-03  5.113509e-04  1.996309e-03  1.270878e-04 -1.508463e-03
      514 -5.488244e-04  8.905851e-04  1.926871e-03 -9.660471e-05  1.456803e-03
      515 -1.934017e-04 -2.892675e-04 -1.858820e-03 -1.256189e-03  7.252882e-04
      516 -5.582868e-04  9.025882e-04  2.079911e-03 -9.067238e-04 -6.309363e-04
      517 -1.036539e-03  5.414347e-06 -1.545143e-03 -6.174202e-04 -4.015383e-04
      518 -1.283595e-04 -5.038467e-04  4.096321e-04 -1.372375e-04 -1.920023e-04
      519 -1.556226e-03 -9.287049e-04  6.857716e-04  1.528450e-04  1.257707e-03
      520 -3.587027e-04 -3.186262e-04  1.829953e-03 -1.119284e-03  1.899872e-03
      521 -4.189676e-04  3.796869e-04 -1.381538e-03  3.350816e-04  2.023570e-03
      522  5.600954e-04  6.373910e-06  6.062484e-04  4.598889e-04 -1.742767e-03
      523 -7.701824e-04  2.128984e-04 -1.643072e-03 -4.415212e-04  2.697115e-04
      524  1.213340e-03 -1.716482e-04 -2.153222e-04 -7.996505e-05  5.203894e-04
      525  1.526930e-03 -2.983083e-04 -2.067049e-03  1.038425e-03  7.686676e-04
      526  9.380617e-04  7.479081e-04 -1.219530e-03  1.111679e-03  1.883600e-03
      527  1.396634e-03  2.154736e-04  1.727139e-03 -7.988118e-04 -3.881125e-05
      528  1.480237e-03  4.727356e-04 -1.714459e-03  7.793307e-04 -1.566646e-03
      529  1.579197e-03 -4.707285e-04  1.067071e-03 -7.622394e-05  1.499277e-03
      530  1.137020e-03 -5.120009e-04 -2.041523e-03  1.206345e-03 -9.281147e-04
      531 -1.116246e-03 -4.209426e-05 -1.817027e-03 -1.311228e-03  1.193320e-03
      532 -8.100919e-04 -1.017240e-03  1.261451e-03 -3.860402e-04 -7.671219e-04
      533 -6.454048e-04  9.010721e-04 -1.032292e-03  1.009237e-03 -1.280639e-03
      534 -1.286130e-03  8.706874e-04  4.171770e-04  2.613708e-04  1.082668e-04
      535  8.130408e-04 -2.086199e-04 -2.026304e-03 -8.395052e-04 -1.936918e-03
      536 -1.453132e-03 -5.462826e-04 -1.901859e-04  1.150275e-03 -5.980070e-05
      537  8.344905e-05  7.213605e-04  1.630340e-03 -5.937423e-04 -1.031871e-03
      538 -1.059222e-03 -4.891180e-04  1.747659e-03 -2.958438e-04  3.388467e-04
      539  4.214760e-04  6.748447e-04 -1.086797e-03 -5.157021e-04  1.524280e-03
      540  4.403499e-04  4.908220e-04 -1.150252e-03 -4.849042e-04  1.054154e-03
      541 -1.122577e-03 -2.024123e-04  1.680199e-03 -1.258627e-03  4.975932e-04
      542 -4.360162e-04  4.075844e-04  1.971763e-03  1.167922e-03  4.862505e-04
      543  7.153387e-04 -7.718195e-04  2.440941e-04  4.349833e-04  1.983122e-03
      544 -1.096547e-03 -5.931219e-04  1.631251e-03 -1.313034e-03  4.585116e-04
      545 -5.413595e-04  9.087705e-04  1.488893e-03 -1.017541e-03  3.247314e-05
      546  1.200896e-03 -9.115379e-04 -1.439408e-03  8.650451e-04 -6.504010e-04
      547 -3.416819e-04 -6.734637e-04 -2.256279e-04 -3.443114e-04 -1.441754e-03
      548 -1.574357e-04 -1.143631e-04 -7.503712e-04 -7.872595e-04  1.819848e-03
      549  5.844712e-04  1.366569e-04 -1.533264e-04  4.180722e-04 -1.651325e-03
      550 -5.317739e-04 -6.957130e-04  5.018705e-04 -5.046543e-04  1.618608e-05
      551  7.312097e-04 -2.069048e-04  1.398378e-03  6.455486e-04  2.015268e-03
      552  1.221460e-03 -9.242240e-04  2.082378e-03  4.842809e-04 -6.072925e-04
      553  3.145419e-04 -1.004860e-03  3.508427e-05  1.849132e-04  2.761947e-05
      554  1.513837e-03  4.110060e-05  2.108086e-03  1.001188e-03  8.030168e-04
      555  9.174625e-04 -1.771742e-04  5.083954e-04  6.524650e-04 -1.173547e-03
      556 -1.396542e-03  7.442711e-04  4.707324e-06  8.468354e-04  1.702194e-03
      557  1.119056e-03 -4.318949e-04  1.578705e-04  1.069125e-03  1.990491e-03
      558 -1.105656e-03  7.842223e-04 -1.222061e-03 -6.032486e-04  1.441402e-03
      559 -2.636334e-04  1.077098e-03 -1.626027e-04 -8.155989e-05 -1.676664e-03
      560  1.324671e-03  6.347945e-04  7.689979e-04  9.441038e-04 -1.035396e-03
      561  1.436860e-03  3.055328e-04 -4.061474e-05  1.182826e-04 -1.464665e-03
      562  5.447600e-04  4.787319e-04 -7.155757e-04  8.406120e-04 -1.129191e-03
      563  1.058016e-03  7.238526e-04  9.320969e-04  9.334883e-04  6.271461e-04
      564 -7.930168e-04  3.460508e-04  2.092790e-03  5.442016e-05  1.346597e-03
      565 -8.343379e-04 -2.438991e-04  4.362121e-04 -6.404784e-04  1.745057e-03
      566  1.205395e-03 -3.289936e-04 -5.055524e-04  5.640314e-05 -9.130737e-04
      567 -1.149893e-03  1.100335e-03  2.734117e-04  9.746888e-05  5.814285e-04
      568 -2.904849e-04  1.075125e-03 -3.056246e-05 -8.313859e-04  7.648788e-04
      569 -4.264085e-04 -1.052462e-03  1.484067e-04  7.553304e-04  2.017996e-03
      570  9.164621e-04 -7.562340e-05 -1.025177e-03  9.332167e-04  1.203226e-03
      571 -1.037864e-03 -1.006730e-03 -2.187121e-03  5.726482e-05 -1.654519e-03
      572  2.195911e-04 -5.078555e-04 -1.071691e-04  6.594851e-04 -1.158152e-03
      573  1.240227e-04 -3.653377e-04 -7.729422e-05 -9.286522e-05  7.030151e-04
      574  4.833145e-04 -3.904935e-07  1.544746e-03 -1.185085e-03 -1.592719e-03
      575  1.102304e-03 -5.824364e-04 -1.385778e-03  1.204718e-03  1.837230e-03
      576 -2.348345e-04 -1.057092e-03  2.983046e-04  1.153467e-03  1.533650e-03
      577  1.403472e-03  1.110827e-03  1.543393e-03 -1.244227e-03  4.962560e-05
      578 -1.154056e-03  1.314914e-04 -1.512534e-03  9.660017e-04  1.583794e-03
      579  6.858358e-04 -4.664490e-05 -1.199466e-03  5.207644e-04  1.149119e-03
      580  5.708100e-04 -9.935774e-04  9.234402e-04 -5.807265e-04 -7.579963e-04
      581  1.416411e-03  4.554801e-04  1.460071e-03 -1.347948e-03 -1.776993e-03
      582  1.402832e-04  5.828303e-04  9.937951e-04 -1.180560e-03 -1.418292e-03
      583 -1.377214e-03  6.889164e-04 -1.029005e-04 -8.427768e-04 -5.144301e-04
      584 -7.030488e-04  1.126443e-03 -1.368453e-03 -3.265086e-04 -1.069245e-03
      585 -1.161770e-03 -1.176993e-03 -7.778171e-04  2.232882e-04  3.389612e-04
      586 -9.045073e-04 -2.998761e-04  2.969684e-04 -1.221111e-03 -1.581919e-03
      587 -9.117821e-05 -3.608559e-04  4.162182e-04  5.509200e-04 -1.123906e-03
      588  1.440881e-03 -2.533985e-04 -1.204023e-04 -2.239021e-04  1.296390e-03
      589  1.206408e-03 -1.634064e-04 -1.781099e-03 -1.171163e-04 -4.291957e-04
      590 -1.104436e-03  9.917576e-04 -1.732682e-04 -9.830751e-04  1.234359e-03
      591 -9.436827e-04 -7.302720e-04  5.793706e-04 -1.794188e-04 -1.757746e-03
      592 -2.825364e-04 -3.717976e-04  5.111302e-04 -3.332539e-04 -7.197519e-04
      593  1.222572e-03 -7.384110e-04  1.567073e-03 -7.593062e-04 -6.426018e-04
      594  1.744539e-04  3.828556e-04  1.761209e-04  8.673885e-04  1.780898e-03
      595  3.160200e-04 -2.454125e-04  4.777749e-04  1.059536e-05 -4.812885e-04
      596 -1.978815e-04 -9.118666e-04 -1.038145e-04 -8.203389e-04 -1.071951e-03
      597  1.278841e-04  3.733149e-04 -1.312636e-03 -1.750320e-04  1.741624e-03
      598 -1.159372e-03  8.216407e-04 -7.708314e-04  8.729129e-05 -9.448842e-04
      599 -2.563615e-04 -1.034758e-03  2.435989e-04  1.080278e-03 -3.517849e-04
      600  1.600759e-04 -1.012704e-03  1.666271e-04  1.071451e-03 -8.216311e-04
      601 -3.675572e-04 -7.302480e-04 -5.863696e-04 -8.822597e-04 -5.955378e-04
      602 -1.255504e-03 -4.465220e-04  5.653589e-05 -1.224214e-04 -1.756236e-03
      603  5.322657e-04 -5.086540e-04 -1.824740e-03  1.048345e-03  8.923764e-05
      604 -7.021613e-04  9.989070e-04  1.249757e-03  1.134969e-03  9.689655e-04
      605 -8.479941e-04 -3.667873e-04 -2.840658e-04 -1.205912e-03  1.072347e-03
      606 -6.348167e-04 -6.458211e-05  7.913659e-04 -1.139837e-03  1.360607e-03
      607  7.501382e-04 -2.916743e-04  1.375729e-03  9.250695e-05 -2.307939e-04
      608 -7.121468e-05  1.268983e-04 -1.578258e-03  4.390469e-04  1.793431e-03
      609  8.076414e-04  3.483433e-04 -5.666205e-04  3.746662e-04 -3.970329e-04
      610  2.949806e-04  4.508754e-04  1.597446e-03  6.709520e-04  1.356496e-03
      611  1.041455e-03 -2.650160e-04 -1.685705e-03  7.059699e-04  1.117490e-03
      612  7.506101e-04  9.934521e-04  7.203616e-04 -4.909541e-04 -1.833496e-03
      613  1.085960e-04 -1.042629e-04  1.561724e-03 -1.071607e-03 -2.417585e-04
      614  1.129997e-04  6.105817e-04 -1.329021e-03 -7.463050e-04  7.335286e-04
      615 -1.368600e-04  7.090905e-04  1.732558e-03 -5.753031e-04  3.157563e-04
      616  1.324459e-03 -3.617209e-04  5.108394e-04  4.285225e-04  1.207970e-03
      617  1.189490e-03  9.528613e-04 -3.508246e-04  2.715383e-04 -5.129094e-04
      618  1.043574e-03  8.445553e-04  7.995918e-04  2.353398e-04 -1.754321e-03
      619  6.397746e-04  1.072608e-03 -1.352507e-03  8.166195e-04 -1.890548e-03
      620  1.011405e-03 -7.621589e-04 -9.854871e-04 -5.086992e-04 -1.159691e-03
      621  7.529302e-04 -4.371544e-05  1.389954e-04  2.050681e-04  2.692694e-04
      622  3.843576e-04 -1.303715e-05 -1.067728e-03 -1.711633e-04  2.285057e-05
      623  5.565687e-04  2.894002e-04 -1.094010e-03 -1.282448e-03 -1.653060e-03
      624 -4.542939e-05 -5.130019e-04 -8.620742e-04 -1.591951e-04 -1.076093e-03
      625 -4.318746e-04  1.127150e-03 -2.080630e-03 -1.701750e-04 -1.232547e-03
      626 -1.393827e-03 -9.190046e-04  2.033660e-03  2.278891e-04 -1.993776e-03
      627 -1.399570e-04  5.309774e-04  7.197330e-04 -1.231884e-03 -1.017821e-03
      628  1.672884e-05  1.647992e-04 -1.037090e-03  5.661611e-04  8.432185e-04
      629 -7.940907e-04  4.757623e-04 -3.601754e-04  5.478635e-04 -1.014125e-03
      630  1.444364e-03 -5.216714e-04  1.086371e-03  2.614772e-04  1.174783e-03
      631  4.239189e-04  2.057006e-04 -9.246729e-04 -5.964791e-04 -1.237649e-03
      632 -2.577554e-04  4.487250e-04  1.336719e-04 -1.244010e-03  1.089328e-03
      633  1.136370e-03  1.067622e-03 -1.549376e-03  2.050310e-04 -1.629989e-03
      634 -1.368368e-03 -2.788958e-04 -2.002985e-03  6.939457e-04  1.614414e-03
      635  8.792670e-04 -2.667222e-04  2.034125e-04  1.242070e-03 -1.137575e-03
      636  1.148989e-03 -7.272240e-04 -1.546380e-03  2.810396e-04  6.482254e-04
      637 -8.496400e-04 -1.142210e-05  1.907753e-03 -5.827283e-04  1.420168e-03
      638  1.559634e-03 -9.888706e-04 -3.278398e-06  8.742078e-04 -1.920094e-03
      639  4.376988e-04 -2.642593e-04  1.797244e-03  8.985041e-04 -2.348916e-04
      640 -4.272042e-04 -1.362427e-04  1.050217e-03 -3.577471e-04  4.962318e-04
      641  8.560990e-04 -6.054426e-04  4.269538e-04 -8.176625e-04 -7.248327e-04
      642 -1.537521e-03 -2.994862e-04  2.082518e-03 -1.237454e-03 -1.916809e-03
      643  2.355161e-04  8.172197e-04 -1.947108e-03 -1.261605e-03  1.881970e-03
      644  1.065417e-03  4.484399e-04 -1.169059e-03 -1.196442e-03 -4.507712e-04
      645  1.508766e-03  3.857475e-04  1.974070e-03  1.742952e-04 -1.020746e-03
      646 -7.820298e-05  6.677948e-04 -4.583754e-04  9.931134e-04 -1.454607e-03
      647  4.536453e-04 -1.104642e-03 -6.164778e-04 -1.371567e-04 -1.081026e-03
      648 -1.368777e-03 -8.702099e-04  1.159589e-03 -2.842695e-04  1.582906e-03
      649 -1.466195e-03  7.025974e-04 -3.593286e-04 -2.659264e-04 -1.404372e-03
      650 -1.688480e-04 -7.774344e-05  1.559973e-03  4.715410e-04 -7.815472e-04
      651  1.438141e-03  3.209289e-04  1.312346e-03  1.126477e-03  3.049279e-04
      652 -8.526746e-04 -8.031071e-04 -6.511551e-04  7.713136e-04 -1.679048e-03
      653 -9.124858e-04  1.042365e-04  1.611107e-03 -1.234607e-03 -1.023670e-03
      654  3.476339e-04 -6.705186e-04  1.063846e-03  2.037608e-05 -1.139167e-04
      655  1.283505e-05  4.696152e-04  1.764062e-03 -1.177623e-03 -1.349556e-03
      656 -6.716530e-04  7.459433e-04  1.631323e-03  9.280488e-04  1.841400e-03
      657 -7.716980e-04 -1.026573e-03 -1.944766e-03  1.127279e-03 -9.834506e-04
      658  4.940418e-04 -5.930910e-04  1.645150e-03 -4.484483e-04  1.656338e-03
      659 -7.831103e-04  4.135382e-06  4.549673e-04  1.215549e-03 -7.333129e-04
      660 -4.783365e-04  2.459877e-04  8.105396e-04 -4.128596e-04 -8.921506e-04
      661 -2.086139e-04 -1.535463e-04  1.694756e-03  1.092581e-04  8.908523e-04
      662 -3.249986e-04  1.761256e-04  6.504309e-04  4.521243e-05 -1.072567e-03
      663  1.281075e-03  9.481783e-04  1.936632e-03 -1.637784e-05 -1.887114e-03
      664 -1.512958e-04  5.641298e-04 -1.923929e-03  7.429928e-04 -9.966609e-05
      665  8.582601e-04 -2.212862e-05  9.963226e-04 -1.187857e-03 -1.915152e-04
      666 -8.338035e-04 -5.145295e-04  1.997831e-03 -8.443434e-04  1.948157e-03
      667  6.730232e-05 -2.900856e-04 -1.285785e-03  6.020678e-04 -1.110517e-03
      668 -4.966011e-04  8.654182e-04 -1.852405e-03  5.805346e-04 -1.993987e-03
      669 -8.708573e-04  1.207620e-04  1.608310e-03  1.016406e-04  7.764659e-04
      670  4.743870e-04 -6.769401e-04 -8.302775e-04  1.043149e-03 -1.068283e-03
      671  1.131042e-03  5.381167e-04  7.239868e-04  2.347780e-05  1.244355e-03
      672  2.602750e-04 -9.831643e-04 -4.881085e-05  2.750803e-04  8.430075e-04
      673 -7.084591e-04 -5.862758e-04 -1.239960e-03 -3.338954e-04 -4.879093e-04
      674  2.201914e-04  1.004165e-04 -2.191172e-03  4.517426e-04 -1.657603e-03
      675  1.389031e-03 -1.002328e-03  8.948956e-04  7.889510e-04 -1.437682e-03
      676 -1.557809e-03 -9.445730e-04  7.725822e-04  7.337492e-04  1.553062e-03
      677 -3.047378e-04 -9.262646e-04  4.684808e-04 -6.791039e-05  5.425400e-04
      678 -1.290772e-03 -8.440922e-04 -1.802606e-03  1.262390e-03  1.601849e-03
      679  1.893974e-04 -6.003521e-04 -1.920532e-03 -1.244380e-03 -5.136050e-04
      680 -1.493033e-03 -6.238918e-04  3.237390e-04 -3.497797e-05  1.186967e-03
      681 -1.277005e-03 -5.922805e-07  1.154542e-03 -1.220109e-03 -8.288553e-04
      682  1.049694e-03 -5.268740e-04 -1.594274e-03 -1.872454e-04 -1.237285e-03
      683  1.539792e-03 -5.486441e-05 -6.552356e-04 -1.635941e-04 -9.567401e-05
      684  5.425636e-04  1.162779e-04  9.819119e-04  1.555495e-04  1.454030e-04
      685  1.120584e-03  1.044148e-03  2.307070e-05  1.223143e-03 -1.748906e-03
      686  8.605288e-04 -2.726217e-04 -2.058504e-03  1.030962e-03  1.281476e-04
      687 -5.098038e-04 -3.087837e-04  1.741600e-03  1.012182e-03  1.476071e-03
      688  4.193938e-04  7.195156e-04  1.546390e-03  8.170534e-04  1.520577e-03
      689 -1.517359e-04  2.977803e-04 -1.170879e-03 -7.499277e-04 -6.406258e-04
      690 -6.248853e-04  2.117938e-04 -1.228448e-03  7.959564e-04 -9.713102e-04
      691  7.101727e-05 -2.063878e-04  4.484974e-04  1.103114e-03  1.637948e-03
      692  2.100184e-05 -3.293398e-04  1.818049e-03  6.360228e-05 -1.081713e-03
      693 -4.367335e-04  9.267739e-04  1.052268e-03  1.112177e-04  7.188777e-05
      694  1.162013e-03  3.438292e-04  6.589495e-06  5.364164e-04 -9.347832e-04
      695 -5.369514e-04 -3.310634e-04 -2.188569e-03  9.304767e-04  1.402904e-03
      696 -1.375617e-03 -4.456061e-04  2.056893e-03  1.161906e-03 -9.762699e-04
      697  2.338727e-04  5.586957e-04  8.000067e-04  1.228751e-03 -8.870067e-05
      698 -7.754415e-04 -7.800744e-04 -1.345593e-03  7.740539e-04  7.692875e-04
      699  1.490782e-03  2.032781e-04 -5.456141e-04  1.134862e-03  6.022075e-04
      700  7.495179e-04  6.343609e-04 -1.577492e-03  2.554277e-04  1.151931e-03

---

    Code
      x$sds
    Output
             x1        x2        x3        x4        x5        x6        x7        x8 
      0.2871632 0.2809696 0.2932114 0.2974998 0.2889343 0.2819647 0.2804975 0.2929078 
             x9       x10 
      0.2898016 0.2806027 

---

    Code
      x$means
    Output
             x1        x2        x3        x4        x5        x6        x7        x8 
      0.5011694 0.5059652 0.4921696 0.4818135 0.5059529 0.4989024 0.5107920 0.5088933 
             x9       x10 
      0.5030058 0.4939303 

---

    Code
      x$importance
    Output
         term     estimate
      1    x1 0.4513503114
      2    x2 0.4050240509
      3    x3 0.1802543852
      4    x4 0.5782718534
      5    x5 0.1561788555
      6    x6 0.0009105000
      7    x7 0.0006527584
      8    x8 0.0012708119
      9    x9 0.0007807150
      10  x10 0.0011424776

---

    Code
      x$d_bar
    Output
      [1] 1.16272

---

    Code
      x$aoa_threshold
    Output
      [1] 0.3080491

---

    Code
      x$blueprint
    Output
      Formula blueprint: 
       
      # Predictors: 10 
        # Outcomes: 1 
         Intercept: FALSE 
      Novel Levels: FALSE 
       Composition: tibble 
        Indicators: traditional 

