% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegen.R
\name{pal_vector}
\alias{pal_vector}
\title{Output a character vector containing code for a palette}
\usage{
pal_vector(
  palette,
  n,
  which = NULL,
  type = c("discrete", "continuous"),
  reverse = FALSE
)
}
\arguments{
\item{palette}{The name of the palette (partial matching supported), or an
actual palette from \verb{[wacolors]}.}

\item{n}{The number of colors in the palette. If this exceeds the actual
number and \code{type} is not provided, it will be set to \code{continuous}.}

\item{which}{if not \code{NULL}, the indices or names of a subset of colors to use.}

\item{type}{Either \code{continuous} or \code{discrete}. Use \code{continuous} if you want
to automatically interpolate between colors.}

\item{reverse}{\code{TRUE} if palette should be reversed.}
}
\value{
The generated code, invisibly, as a character vector.
}
\description{
Call this function to get the code for a character vector containing a
palette.  If using RStudio, the code will be loaded at the console prompt;
otherwise, it will be printed at the terminal.
}
\examples{
pal_vector("rainier", 4)

}
